/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import androidx.annotation.Nullable;
import com.amazon.aps.ads.privacy.ApsPrivacyManager;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.PrivacyLocationMode;
import java.math.BigDecimal;
import java.math.RoundingMode;

class DtbGeoLocation {
    private static final String LOG_TAG = DtbGeoLocation.class.getSimpleName();
    private static final float THRESHOLD_DISTANCE_IN_KILOMETERS = 3.0f;
    private static final float ACCURACY_IN_METERS_FINE_PERMISSION_FIX_MODE = 1.0f;
    private static final float ACCURACY_IN_METERS_COARSE_PERMISSION_FIX_MODE = 2000.0f;
    private static final int GEO_LOCATION_LAST_KNOWN_LOCATION_DURATION_IN_SECONDS = 86400;
    private static final float[] distanceStandardInComputeMode = new float[]{111000.0f, 11100.0f, 1110.0f, 111.0f, 11.1f, 1.11f, 0.111f};

    DtbGeoLocation() {
        if (AdRegistration.getContext() == null) {
            DtbLog.debugError(LOG_TAG, "unable to initialize DtbGeoLocation without setting app context");
            throw new IllegalArgumentException("unable to initialize DtbGeoLocation without setting app context");
        }
    }

    @Nullable
    public String getLocationParam() {
        if (!ApsPrivacyManager.INSTANCE.isSystemResourceAccessAllowed()) {
            return null;
        }
        Location location = this.retrieveGeoLocationWithMode();
        if (location == null) {
            return null;
        }
        long lastKnownLocationDurationInSeconds = (System.currentTimeMillis() - location.getTime()) / 1000L;
        if (lastKnownLocationDurationInSeconds > 86400L) {
            return null;
        }
        return location.getLatitude() + "," + location.getLongitude() + "," + location.getAccuracy() + "," + lastKnownLocationDurationInSeconds;
    }

    @Nullable
    Location retrieveGeoLocationWithMode() {
        try {
            DtbSharedPreferences dtbSharedPreferences = DtbSharedPreferences.getInstance();
            if (dtbSharedPreferences == null) {
                return null;
            }
            PrivacyLocationMode mode = dtbSharedPreferences.getPrivacyLocationConfigMode();
            float accuracyInMeters = dtbSharedPreferences.getPrivacyLocationConfigAccuracyInMeters();
            long configCheckInTimeToLive = DtbSharedPreferences.getInstance().getConfigTtlInMilliSeconds();
            long configLastCheckInTimeStamp = DtbSharedPreferences.getInstance().getConfigLastCheckIn();
            if (!DTBMetricsConfiguration.getInstance().isFeatureEnabled("config_check_in_ttl_feature_v2")) {
                configCheckInTimeToLive = 172800000L;
            }
            if (System.currentTimeMillis() - configLastCheckInTimeStamp > configCheckInTimeToLive) {
                return null;
            }
            Context context = AdRegistration.getContext();
            if (!this.hasLocationPermission(context)) {
                return null;
            }
            switch (mode) {
                case FIXED: {
                    return this.getLocationInFixMode(accuracyInMeters);
                }
                case COMPUTE: {
                    return this.getLocationInComputeMode(accuracyInMeters);
                }
            }
            return null;
        }
        catch (RuntimeException exception) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute retrieveGeoLocationWithMode method", exception);
            return null;
        }
    }

    @Nullable
    Location getLocationInFixMode(float accuracyInMeters) {
        float accuracyFixMode = 0.0f;
        Context context = AdRegistration.getContext();
        if (this.hasLocationFinePermission(context)) {
            accuracyFixMode = 1.0f;
        } else if (this.hasLocationCoarsePermission(context)) {
            accuracyFixMode = 2000.0f;
        }
        if (accuracyInMeters > accuracyFixMode) {
            return null;
        }
        return this.getLocation();
    }

    @Nullable
    Location getLocationInComputeMode(float accuracyInMeters) {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        float detectedAccuracy = location.getAccuracy();
        if (accuracyInMeters <= detectedAccuracy) {
            return location;
        }
        float accuracyComputeMode = accuracyInMeters - detectedAccuracy;
        for (int degree = distanceStandardInComputeMode.length - 1; degree >= 0; --degree) {
            if (!(accuracyComputeMode <= distanceStandardInComputeMode[degree])) continue;
            BigDecimal decimalLatitude = BigDecimal.valueOf(location.getLatitude());
            BigDecimal decimalLongitude = BigDecimal.valueOf(location.getLongitude());
            decimalLatitude = decimalLatitude.setScale(degree, RoundingMode.HALF_UP);
            decimalLongitude = decimalLongitude.setScale(degree, RoundingMode.HALF_UP);
            location.setLatitude(decimalLatitude.doubleValue());
            location.setLongitude(decimalLongitude.doubleValue());
            location.setAccuracy(distanceStandardInComputeMode[degree]);
            return location;
        }
        return null;
    }

    @Nullable
    Location getLocation() {
        Location result = null;
        Context context = AdRegistration.getContext();
        Location gpsLocation = this.getLastLocation(context, "gps");
        Location networkLocation = this.getLastLocation(context, "network");
        if (gpsLocation != null && networkLocation != null) {
            float distanceInKilometers = gpsLocation.distanceTo(networkLocation) / 1000.0f;
            if (distanceInKilometers <= 3.0f) {
                float networkLocationAccuracy;
                float gpsLocationAccuracy = gpsLocation.hasAccuracy() ? gpsLocation.getAccuracy() : Float.MAX_VALUE;
                float f = networkLocationAccuracy = networkLocation.hasAccuracy() ? networkLocation.getAccuracy() : Float.MAX_VALUE;
                if (gpsLocationAccuracy < networkLocationAccuracy) {
                    DtbLog.debug(LOG_TAG, "Setting location using GPS determined by accuracy");
                    result = gpsLocation;
                } else {
                    DtbLog.debug(LOG_TAG, "Setting location using network determined by accuracy");
                    result = networkLocation;
                }
            } else if (gpsLocation.getTime() > networkLocation.getTime()) {
                DtbLog.debug(LOG_TAG, "Setting location using GPS determined by time");
                result = gpsLocation;
            } else {
                DtbLog.debug(LOG_TAG, "Setting location using network determined by time");
                result = networkLocation;
            }
        } else if (gpsLocation != null) {
            DtbLog.debug(LOG_TAG, "Setting location using gps, network not available");
            result = gpsLocation;
        } else if (networkLocation != null) {
            DtbLog.debug(LOG_TAG, "Setting location using network, gps not available");
            result = networkLocation;
        }
        return result;
    }

    @Nullable
    Location getLastLocation(Context context, String provider) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        Location location = null;
        try {
            if (lm != null) {
                location = lm.getLastKnownLocation(provider);
            }
        }
        catch (SecurityException e) {
            DtbLog.warn(LOG_TAG, "Failed to retrieve location: No permissions to access " + provider);
        }
        catch (IllegalArgumentException e) {
            DtbLog.warn(LOG_TAG, "Failed to retrieve location: " + provider + "not found");
        }
        return location;
    }

    private boolean hasLocationPermission(Context context) {
        return this.hasLocationFinePermission(context) || this.hasLocationCoarsePermission(context);
    }

    private boolean hasLocationFinePermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private boolean hasLocationCoarsePermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0;
    }
}

