/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.ads.privacy.ApsPrivacyManager;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbFireOSServiceAdapter;
import com.amazon.device.ads.DtbGooglePlayServicesAdapter;
import com.amazon.device.ads.DtbLog;

class DtbGooglePlayServices {
    private static final String LOG_TAG = DtbGooglePlayServices.class.getSimpleName();

    DtbGooglePlayServices() {
    }

    public AdvertisingInfo getAdvertisingIdentifierInfo() {
        DtbGooglePlayServicesAdapter googlePlayServicesAdapter;
        AdvertisingInfo advertisingInfo = null;
        boolean isClassAvailable = this.isAdvertisingClassAvailable();
        if (isClassAvailable && (advertisingInfo = (googlePlayServicesAdapter = DtbGooglePlayServicesAdapter.newAdapter()).getAdvertisingIdentifierInfo()).getAdvertisingIdentifier() != null && !advertisingInfo.getAdvertisingIdentifier().isEmpty()) {
            return advertisingInfo;
        }
        DtbFireOSServiceAdapter dtbFireOSServiceAdapter = DtbFireOSServiceAdapter.newAdapter();
        AdvertisingInfo fireAdInfo = dtbFireOSServiceAdapter.getAdvertisingIdentifierInfo();
        if (fireAdInfo.getAdvertisingIdentifier() != null && !fireAdInfo.getAdvertisingIdentifier().isEmpty()) {
            return fireAdInfo;
        }
        DtbLog.error(LOG_TAG, "The Google Play Services Advertising Identifier feature is not available. Please include the google dependency / check the proguard rule");
        APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "The Google Play Services Advertising Identifier feature is not available");
        return AdvertisingInfo.createNotAvailable();
    }

    private boolean isAdvertisingClassAvailable() {
        return DtbCommonUtils.isClassAvailable("com.google.android.gms.ads.identifier.AdvertisingIdClient");
    }

    static class AdvertisingInfo {
        private boolean gpsAvailable = true;
        private String advertisingIdentifier;
        private Boolean limitAdTrackingEnabled;

        AdvertisingInfo() {
        }

        static AdvertisingInfo createNotAvailable() {
            return new AdvertisingInfo().setGooglePlayServicesAvailable(false);
        }

        boolean isGooglePlayServicesAvailable() {
            return this.gpsAvailable;
        }

        private AdvertisingInfo setGooglePlayServicesAvailable(boolean gpsAvailable) {
            this.gpsAvailable = gpsAvailable;
            return this;
        }

        String getAdvertisingIdentifier() {
            if (ApsPrivacyManager.INSTANCE.isSystemResourceAccessAllowed()) {
                return this.advertisingIdentifier;
            }
            return null;
        }

        AdvertisingInfo setAdvertisingIdentifier(String advertisingIdentifier) {
            this.advertisingIdentifier = advertisingIdentifier;
            return this;
        }

        boolean hasAdvertisingIdentifier() {
            return this.getAdvertisingIdentifier() != null;
        }

        Boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }

        AdvertisingInfo setLimitAdTrackingEnabled(Boolean limitAdTrackingEnabled) {
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            return this;
        }
    }
}

