/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbConstants;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbThreadService;
import com.iab.omid.library.amazon.Omid;
import com.iab.omid.library.amazon.adsession.AdEvents;
import com.iab.omid.library.amazon.adsession.AdSession;
import com.iab.omid.library.amazon.adsession.AdSessionConfiguration;
import com.iab.omid.library.amazon.adsession.AdSessionContext;
import com.iab.omid.library.amazon.adsession.CreativeType;
import com.iab.omid.library.amazon.adsession.FriendlyObstructionPurpose;
import com.iab.omid.library.amazon.adsession.ImpressionType;
import com.iab.omid.library.amazon.adsession.Owner;
import com.iab.omid.library.amazon.adsession.Partner;
import java.util.List;

public class DtbOmSdkSessionManager {
    private static final String LOGTAG = DtbOmSdkSessionManager.class.getSimpleName();
    private static final String APS_OMSDK_ACTIVATION_NOT_INITIALIZED_MESSAGE = "OMIDSDK Activation failed to initialize";
    private static final String APS_OM_SDK_PARTNER_OBJECT_ERROR_MESSAGE = "OMIDSDK Failed to create partner object";
    private static final String APS_OM_SDK_ACTIVATION_ERROR_MESSAGE = "OMIDSDK Failed to activate";
    private static final String APS_OM_SDK_AD_SESSION_CONFIG_ERROR_MESSAGE = "OMIDSDK Failed to initialize config for ";
    private static final String APS_OM_SDK_AD_SESSION_CREATION_ERROR_MESSAGE = "OMIDSDK Failed to create ad session";
    private static final String APS_OM_SDK_AD_EVENTS_CREATION_ERROR_MESSAGE = "OMIDSDK Failed to create ad event";
    private static final String APS_OM_SDK_REGISTER_AD_VIEW_ERROR_MESSAGE = "OMIDSDK Failed to register ad view";
    private static final String APS_OM_SDK_START_AD_SESSION_ERROR_MESSAGE = "OMIDSDK Failed to start ad session";
    private static final String APS_OM_SDK_LOAD_EVENT_ERROR_MESSAGE = "OMIDSDK Failed to load ad event";
    private static final String APS_OM_SDK_IMPRESSION_ERROR_MESSAGE = "OMIDSDK Failed to trigger impression event";
    private static final String APS_OM_SDK_STOP_AD_SESSION_ERROR_MESSAGE = "OMIDSDK Failed to stop ad session";
    private static final String APS_OM_SDK_ADD_FRIENDLY_OBSTRUCTION_ERROR_MESSAGE = "OMIDSDK Failed to add friendly obstruction";
    private static boolean featureEnabled;
    private static boolean isOmSdkActive;
    private Partner dtbOmSdkPartner;
    private AdSession dtbOmSdkAdSession;
    private AdEvents dtbOmSdkAdEvents;
    private AdSessionContext adSessionContext;
    private AdSessionConfiguration adSessionConfiguration;

    private DtbOmSdkSessionManager() {
        this.computeFeatureEnabledFlag();
        if (featureEnabled) {
            DtbThreadService.executeOnMainThread(() -> {
                try {
                    String OmSdkPartnerName = DTBMetricsConfiguration.getClientConfigVal("partner_name", "Amazon1", "om_sdk_feature");
                    this.dtbOmSdkPartner = Partner.createPartner((String)OmSdkPartnerName, (String)DtbCommonUtils.getSDKVersion());
                }
                catch (RuntimeException e) {
                    APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, APS_OM_SDK_PARTNER_OBJECT_ERROR_MESSAGE, e);
                }
            });
        }
    }

    private void computeFeatureEnabledFlag() {
        List<String> OmSdkVersionList = DTBMetricsConfiguration.getDeniedOmSdkVersionList("denied_version_list");
        if (OmSdkVersionList.isEmpty()) {
            featureEnabled = true;
            return;
        }
        featureEnabled = !OmSdkVersionList.contains(DtbConstants.INTEGRATED_OM_VERSION.replaceAll("_", "."));
    }

    protected static void activateOMSDK(Context applicationContext) {
        DtbThreadService.executeOnMainThread(() -> {
            try {
                Class.forName("com.iab.omid.library.amazon.Omid");
                Omid.activate((Context)applicationContext);
                isOmSdkActive = Omid.isActive();
            }
            catch (Throwable e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_ACTIVATION_ERROR_MESSAGE, (Exception)e);
            }
        });
    }

    public static DtbOmSdkSessionManager getNewInstance() {
        if (!isOmSdkActive) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, APS_OMSDK_ACTIVATION_NOT_INITIALIZED_MESSAGE);
            return null;
        }
        return new DtbOmSdkSessionManager();
    }

    public void initHtmlDisplayOmAdSession(WebView webView, String contentUrl) {
        this.initOmAdSession(webView, contentUrl, CreativeType.HTML_DISPLAY, Owner.NATIVE, Owner.NONE, false);
    }

    public void initJavaScriptOmAdSession(WebView webView, String contentUrl) {
        this.initOmAdSession(webView, contentUrl, CreativeType.DEFINED_BY_JAVASCRIPT, Owner.JAVASCRIPT, Owner.JAVASCRIPT, true);
    }

    private void initOmAdSession(WebView webView, String contentUrl, CreativeType creativeType, Owner impressionOwner, Owner mediaEventOwner, boolean isolateVerificationScriptsFlag) {
        if (!featureEnabled) {
            DtbLog.error(LOGTAG, "OM SDK Feature Turned Off");
            return;
        }
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkPartner == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, APS_OM_SDK_PARTNER_OBJECT_ERROR_MESSAGE);
                return;
            }
            try {
                this.adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)creativeType, (ImpressionType)ImpressionType.BEGIN_TO_RENDER, (Owner)impressionOwner, (Owner)mediaEventOwner, (boolean)isolateVerificationScriptsFlag);
                this.adSessionContext = AdSessionContext.createHtmlAdSessionContext((Partner)this.dtbOmSdkPartner, (WebView)webView, (String)contentUrl, (String)"");
                this.createOmAdSession(this.adSessionConfiguration, this.adSessionContext);
                if (CreativeType.HTML_DISPLAY.equals((Object)creativeType)) {
                    this.createOmAdEvents();
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_AD_SESSION_CONFIG_ERROR_MESSAGE + creativeType, e);
            }
        });
    }

    private void createOmAdSession(AdSessionConfiguration adSessionConfiguration, AdSessionContext adSessionContext) {
        if (adSessionConfiguration == null || adSessionContext == null) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, APS_OM_SDK_AD_SESSION_CREATION_ERROR_MESSAGE);
            return;
        }
        this.dtbOmSdkAdSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
        DtbLog.info(LOGTAG, "OMSDK : Open measurement ad Session Created");
    }

    private void createOmAdEvents() {
        if (this.dtbOmSdkAdSession == null) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "OMIDSDK Failed to create ad event on create Ad Event");
            return;
        }
        this.dtbOmSdkAdEvents = AdEvents.createAdEvents((AdSession)this.dtbOmSdkAdSession);
        DtbLog.info(LOGTAG, "OMSDK : Open measurement ad Event created");
    }

    public void registerAdView(WebView view) {
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkAdSession == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "OMIDSDK Failed to create ad session on register Ad View");
                return;
            }
            try {
                this.dtbOmSdkAdSession.registerAdView((View)view);
                DtbLog.info(LOGTAG, "OMSDK : Open measurement ad view registered");
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_REGISTER_AD_VIEW_ERROR_MESSAGE, e);
            }
        });
    }

    public void startAdSession() {
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkAdSession == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "OMIDSDK Failed to create ad session on start Ad Session");
                return;
            }
            try {
                this.dtbOmSdkAdSession.start();
                DtbLog.info(LOGTAG, "OMSDK : Open measurement ad session id: " + this.dtbOmSdkAdSession.getAdSessionId());
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_START_AD_SESSION_ERROR_MESSAGE, e);
            }
        });
    }

    public void displayAdEventLoaded() {
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkAdEvents == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "OMIDSDK Failed to create ad event on adLoaded event");
                return;
            }
            try {
                this.dtbOmSdkAdEvents.loaded();
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_LOAD_EVENT_ERROR_MESSAGE, e);
            }
        });
    }

    protected AdSession getCurrentAdSession() {
        return this.dtbOmSdkAdSession;
    }

    protected AdEvents getCurrentAdEvents() {
        return this.dtbOmSdkAdEvents;
    }

    protected void impressionOccured() {
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkAdEvents == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "OMIDSDK Failed to create ad event on impressionOccured");
                return;
            }
            try {
                this.dtbOmSdkAdEvents.impressionOccurred();
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_IMPRESSION_ERROR_MESSAGE, e);
            }
        });
    }

    public synchronized void stopOmAdSession() {
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkAdSession == null || !isOmSdkActive) {
                DtbLog.error(LOGTAG, "OMSDK : Open measurement ad Session not active");
                return;
            }
            try {
                this.dtbOmSdkAdSession.finish();
                this.adSessionContext = null;
                this.dtbOmSdkAdSession = null;
                this.dtbOmSdkAdEvents = null;
                this.adSessionConfiguration = null;
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_STOP_AD_SESSION_ERROR_MESSAGE, e);
            }
        });
    }

    public void addFriendlyObstruction(View view, FriendlyObstructionPurpose friendlyObstructionPurpose) {
        DtbThreadService.executeOnMainThread(() -> {
            if (this.dtbOmSdkAdSession == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "OMIDSDK Failed to create ad session on add Friendly Obstruction");
                return;
            }
            try {
                this.dtbOmSdkAdSession.addFriendlyObstruction(view, friendlyObstructionPurpose, null);
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, APS_OM_SDK_ADD_FRIENDLY_OBSTRUCTION_ERROR_MESSAGE);
            }
        });
    }

    public static boolean getFeatureEnableFlag() {
        return featureEnabled;
    }

    protected static boolean isOmSdkActive() {
        return isOmSdkActive;
    }
}

