/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DtbCommonUtils;

public class DtbPricePoint {
    private final String pricePoint;
    private final DTBAdSize adSize;

    public DtbPricePoint(String pricePoint, String size, String slotUUID, AdType adType) {
        this.pricePoint = pricePoint;
        String[] adSizeArr = size.split("x");
        if (adSizeArr.length != 2) {
            throw new IllegalArgumentException("AdSize " + size + " is not valid");
        }
        int width = DtbCommonUtils.parseInt(adSizeArr[0], 0);
        int height = DtbCommonUtils.parseInt(adSizeArr[1], 0);
        this.adSize = new DTBAdSize(width, height, adType, slotUUID);
    }

    public String getPricePoint() {
        return this.pricePoint;
    }

    public DTBAdSize getAdSize() {
        return this.adSize;
    }

    public String toString() {
        return "DtbPricePoint [pricePoint=" + this.pricePoint + ", adSize=" + this.adSize + "]";
    }
}

