/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.Handler;
import android.os.Looper;
import com.amazon.device.ads.DtbLog;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class DtbThreadService {
    private boolean shutdownInProgress = false;
    private static final long SCHEDULE_INTERVAL = 10L;
    private static final DtbThreadService threadServiceInstance = new DtbThreadService();
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private ScheduledExecutorService scheduler;

    private DtbThreadService() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                threadServiceInstance.shutdownInProgress = true;
                DtbLog.debug("App is shutting down, terminating the fixed thread pool");
                DtbThreadService.this.executor.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                threadServiceInstance.shutdownInProgress = true;
                DtbLog.debug("App is shutting down, terminating the thread pool");
                if (DtbThreadService.this.scheduler != null) {
                    DtbThreadService.this.scheduler.shutdown();
                }
            }
        });
    }

    static DtbThreadService getInstance() {
        return threadServiceInstance;
    }

    void execute(Runnable runnable) {
        try {
            if (!this.shutdownInProgress) {
                this.executor.execute(runnable);
            }
        }
        catch (InternalError error) {
            this.handleError(error);
        }
    }

    void schedule(Runnable runnable) {
        try {
            if (!this.shutdownInProgress) {
                if (this.scheduler == null) {
                    this.scheduler = Executors.newScheduledThreadPool(1);
                }
                this.scheduler.schedule(runnable, 10L, TimeUnit.SECONDS);
            }
        }
        catch (InternalError error) {
            this.handleError(error);
        }
    }

    private void handleError(InternalError error) {
        if (error.getLocalizedMessage().contains("shutdown")) {
            // empty if block
        }
        throw error;
    }

    static void executeOnMainThread(Runnable proc) {
        Handler h = new Handler(Looper.getMainLooper());
        h.post(proc);
    }
}

