/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbHttpClient;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.DtbThreadService;
import com.amazon.device.ads.WebResourceOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class WebResourceService
implements Runnable {
    private static final String LOG_TAG = WebResourceService.class.getSimpleName();
    private static final long REFRESH_INTERVAL = 86400000L;
    private static final String WEB_DIR = "/mdtb_web/";
    private static WebResourceService theService;
    private static boolean inProgress;

    public static void init() {
        try {
            if (inProgress) {
                return;
            }
            WebResourceService service = WebResourceService.getInstance();
            DtbSharedPreferences sp = DtbSharedPreferences.getInstance();
            Long when = sp.getWebResoucesLastPing();
            if (when == null || new Date().getTime() - when > 86400000L) {
                inProgress = true;
                DtbThreadService.getInstance().execute(service);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute init method", e);
        }
    }

    public static WebResourceService getInstance() {
        if (theService == null) {
            theService = new WebResourceService();
        }
        return theService;
    }

    @Override
    public void run() {
        try {
            this.createWebDirIfNeeded();
            boolean noExceptions = true;
            for (String url : WebResourceOptions.getCDNResources()) {
                try {
                    DtbHttpClient client = new DtbHttpClient(WebResourceOptions.getCDNHost(url) + url);
                    client.setUseSecure(DtbDebugProperties.getIsSecure(true));
                    client.executeGET(60000);
                    if (client.getResponseCode() != 200) {
                        throw new RuntimeException("resource " + url + " not available");
                    }
                    String content = client.getResponse();
                    File fileDir = AdRegistration.getContext().getFilesDir();
                    File f = File.createTempFile("dtb-temp", "js", fileDir);
                    FileWriter out = new FileWriter(f);
                    out.write(content);
                    out.close();
                    File dest = new File(fileDir.getAbsolutePath() + WEB_DIR + url);
                    this.renameTo(f, dest);
                }
                catch (Exception e) {
                    DtbLog.error("Error registering device for ads:" + e);
                    noExceptions = false;
                }
            }
            if (noExceptions) {
                DtbSharedPreferences sp = DtbSharedPreferences.getInstance();
                sp.saveWebResoucesLastPing(new Date().getTime());
            }
            inProgress = false;
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute init method", e);
        }
    }

    private void createWebDirIfNeeded() {
        File fileDir = AdRegistration.getContext().getFilesDir();
        File dir = new File(fileDir.getAbsolutePath() + WEB_DIR);
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists()) {
            return;
        }
        dir.mkdir();
    }

    void deleteWebDirContent() {
        File fileDir = AdRegistration.getContext().getFilesDir();
        File dir = new File(fileDir.getAbsolutePath() + WEB_DIR);
        if (dir.exists() && dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                child.delete();
            }
        }
    }

    private synchronized void renameTo(File f, File dest) {
        f.renameTo(dest);
    }

    public synchronized String loadFile(String fileName) throws IOException {
        String str;
        File fileDir = AdRegistration.getContext().getFilesDir();
        File f = new File(fileDir.getAbsolutePath() + WEB_DIR + fileName + ".js");
        if (!f.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(f);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            str = str.trim();
            sb.append(str).append("\n");
        }
        reader.close();
        ((InputStream)is).close();
        return sb.toString();
    }

    static {
        inProgress = false;
    }
}

