/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amazon.a.a.o.f;
import com.amazon.device.iap.internal.model.ProductBuilder;
import com.amazon.device.iap.model.CoinsReward;
import com.amazon.device.iap.model.ProductType;
import com.amazon.device.iap.model.Promotion;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Product
implements Parcelable {
    private static final String SKU = "sku";
    private static final String PRODUCT_TYPE = "productType";
    private static final String DESCRIPTION = "description";
    private static final String PRICE = "price";
    private static final String SMALL_ICON_URL = "smallIconUrl";
    private static final String TITLE = "title";
    private static final String COINS_REWARD_AMOUNT = "coinsRewardAmount";
    private static final String SUBSCRIPTION_PERIOD = "subscriptionPeriod";
    private static final String FREE_TRIAL_PERIOD = "freeTrialPeriod";
    private static final String PROMOTIONS = "promotions";
    private final String sku;
    private final ProductType productType;
    private final String description;
    private final String price;
    private final String smallIconUrl;
    private final String title;
    private final CoinsReward coinsReward;
    private final String subscriptionPeriod;
    private final String freeTrialPeriod;
    private List<Promotion> promotions;
    public static final Parcelable.Creator<Product> CREATOR = new Parcelable.Creator<Product>(){

        public Product createFromParcel(Parcel parcel) {
            return new Product(parcel);
        }

        public Product[] newArray(int n) {
            return new Product[n];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.sku);
        parcel.writeString(this.productType.toString());
        parcel.writeString(this.description);
        parcel.writeString(this.price);
        parcel.writeString(this.smallIconUrl);
        parcel.writeString(this.title);
        parcel.writeInt(this.getCoinsRewardAmount());
        parcel.writeString(this.subscriptionPeriod);
        parcel.writeString(this.freeTrialPeriod);
        parcel.writeTypedList(this.promotions);
    }

    private Product(Parcel parcel) {
        this.sku = parcel.readString();
        this.productType = ProductType.valueOf(parcel.readString());
        this.description = parcel.readString();
        this.price = parcel.readString();
        this.smallIconUrl = parcel.readString();
        this.title = parcel.readString();
        int n = parcel.dataAvail() > 0 ? parcel.readInt() : 0;
        this.coinsReward = CoinsReward.from(n);
        this.subscriptionPeriod = parcel.readString();
        this.freeTrialPeriod = parcel.readString();
        this.promotions = parcel.createTypedArrayList(Promotion.CREATOR);
    }

    public Product(ProductBuilder productBuilder) {
        f.a((Object)productBuilder.getSku(), SKU);
        f.a((Object)productBuilder.getProductType(), PRODUCT_TYPE);
        f.a((Object)productBuilder.getDescription(), DESCRIPTION);
        f.a((Object)productBuilder.getTitle(), TITLE);
        f.a((Object)productBuilder.getSmallIconUrl(), SMALL_ICON_URL);
        if (ProductType.SUBSCRIPTION != productBuilder.getProductType()) {
            f.a((Object)productBuilder.getPrice(), PRICE);
        }
        this.sku = productBuilder.getSku();
        this.productType = productBuilder.getProductType();
        this.description = productBuilder.getDescription();
        this.price = productBuilder.getPrice();
        this.smallIconUrl = productBuilder.getSmallIconUrl();
        this.title = productBuilder.getTitle();
        this.coinsReward = CoinsReward.from(productBuilder.getCoinsRewardAmount());
        this.subscriptionPeriod = productBuilder.getSubscriptionPeriod();
        this.freeTrialPeriod = productBuilder.getFreeTrialPeriod();
        this.promotions = productBuilder.getPromotions();
    }

    public String getSku() {
        return this.sku;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrice() {
        return this.price;
    }

    public String getSmallIconUrl() {
        return this.smallIconUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public CoinsReward getCoinsReward() {
        return this.coinsReward;
    }

    private int getCoinsRewardAmount() {
        return this.coinsReward == null ? 0 : this.coinsReward.getAmount();
    }

    public String getSubscriptionPeriod() {
        return this.subscriptionPeriod;
    }

    public String getFreeTrialPeriod() {
        return this.freeTrialPeriod;
    }

    public List<Promotion> getPromotions() {
        return this.promotions;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(SKU, (Object)this.sku);
        jSONObject.put(PRODUCT_TYPE, (Object)this.productType);
        jSONObject.put(DESCRIPTION, (Object)this.description);
        jSONObject.put(PRICE, (Object)this.price);
        jSONObject.put(SMALL_ICON_URL, (Object)this.smallIconUrl);
        jSONObject.put(TITLE, (Object)this.title);
        jSONObject.put(COINS_REWARD_AMOUNT, this.getCoinsRewardAmount());
        if (this.subscriptionPeriod != null) {
            jSONObject.put(SUBSCRIPTION_PERIOD, (Object)this.subscriptionPeriod);
        }
        if (this.freeTrialPeriod != null) {
            jSONObject.put(FREE_TRIAL_PERIOD, (Object)this.freeTrialPeriod);
        }
        if (this.promotions != null) {
            JSONArray jSONArray = new JSONArray();
            for (Promotion promotion : this.promotions) {
                jSONArray.put((Object)promotion.toJSON());
            }
            jSONObject.put(PROMOTIONS, (Object)jSONArray);
        }
        return jSONObject;
    }

    public String toString() {
        String string = null;
        try {
            string = this.toJSON().toString(4);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string;
    }
}

