/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.model;

import com.amazon.a.a.o.f;
import com.amazon.device.iap.internal.model.ProductDataResponseBuilder;
import com.amazon.device.iap.model.Product;
import com.amazon.device.iap.model.RequestId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductDataResponse {
    private static final String PRODUCT_DATA = "productData";
    private static final String REQUEST_STATUS = "requestStatus";
    private static final String REQUEST_ID = "requestId";
    private static final String UNAVAILABLE_SKUS = "UNAVAILABLE_SKUS";
    private static final String TO_STRING_FORMAT = "(%s, requestId: \"%s\", unavailableSkus: %s, requestStatus: \"%s\", productData: %s)";
    private final RequestId requestId;
    private final Set<String> unavailableSkus;
    private final RequestStatus requestStatus;
    private final Map<String, Product> productData;

    public ProductDataResponse(ProductDataResponseBuilder productDataResponseBuilder) {
        f.a(productDataResponseBuilder.getRequestId(), REQUEST_ID);
        f.a((Object)productDataResponseBuilder.getRequestStatus(), REQUEST_STATUS);
        if (productDataResponseBuilder.getUnavailableSkus() == null) {
            productDataResponseBuilder.setUnavailableSkus(new HashSet<String>());
        }
        if (RequestStatus.SUCCESSFUL == productDataResponseBuilder.getRequestStatus()) {
            f.a(productDataResponseBuilder.getProductData(), PRODUCT_DATA);
        } else {
            productDataResponseBuilder.setProductData(new HashMap<String, Product>());
        }
        this.requestId = productDataResponseBuilder.getRequestId();
        this.requestStatus = productDataResponseBuilder.getRequestStatus();
        this.unavailableSkus = productDataResponseBuilder.getUnavailableSkus();
        this.productData = productDataResponseBuilder.getProductData();
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Set<String> getUnavailableSkus() {
        return this.unavailableSkus;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public Map<String, Product> getProductData() {
        return this.productData;
    }

    public String toString() {
        return String.format(TO_STRING_FORMAT, super.toString(), this.requestId, this.unavailableSkus != null ? this.unavailableSkus.toString() : "null", this.requestStatus != null ? this.requestStatus.toString() : "null", this.productData != null ? this.productData.toString() : "null");
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(REQUEST_ID, (Object)this.requestId);
        jSONObject.put(UNAVAILABLE_SKUS, this.unavailableSkus);
        jSONObject.put(REQUEST_STATUS, (Object)this.requestStatus);
        JSONObject jSONObject2 = new JSONObject();
        if (this.productData != null) {
            for (String string : this.productData.keySet()) {
                jSONObject2.put(string, (Object)this.productData.get(string).toJSON());
            }
        }
        jSONObject.put(PRODUCT_DATA, (Object)jSONObject2);
        return jSONObject;
    }

    public static enum RequestStatus {
        SUCCESSFUL,
        FAILED,
        NOT_SUPPORTED;

    }
}

