/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.io.Writable;

public class DynamoDBItemWritable
implements Writable,
Serializable {
    public static final Type type = new TypeToken<Map<String, AttributeValue>>(){}.getType();
    static final String START_OF_TEXT = Character.toString('\u0002');
    static final String END_OF_TEXT = Character.toString('\u0003');
    private static final char FIRST_MAGIC_BYTES = '\u0001';
    private static final byte NEXT_MAGIC_BYTE = 0;
    private Map<String, AttributeValue> dynamoDBItem;

    public DynamoDBItemWritable() {
        this.dynamoDBItem = new HashMap<String, AttributeValue>();
    }

    public DynamoDBItemWritable(Map<String, AttributeValue> dynamoDBItem) {
        this.dynamoDBItem = dynamoDBItem;
    }

    public void readFields(DataInput in) throws IOException {
        this.readFieldsStream(this.readStringFromDataInput(in));
    }

    private String readStringFromDataInput(DataInput in) throws IOException {
        byte[] data;
        char firstBytes = in.readChar();
        if (firstBytes == '\u0001') {
            byte nextByte = in.readByte();
            if (nextByte == 0) {
                return this.readChunks(in);
            }
            data = new byte[]{(byte)(firstBytes >> 8), (byte)firstBytes, nextByte};
        } else {
            data = new byte[firstBytes + 2];
            data[0] = (byte)(firstBytes >> 8);
            data[1] = (byte)firstBytes;
            in.readFully(data, 2, firstBytes);
        }
        return new DataInputStream(new ByteArrayInputStream(data)).readUTF();
    }

    private String readChunks(DataInput in) throws IOException {
        int numChunks = in.readInt();
        StringBuilder whole = new StringBuilder();
        for (int c = 0; c < numChunks; ++c) {
            String chunk = in.readUTF();
            whole.append(chunk);
        }
        return whole.toString();
    }

    public void write(DataOutput out) throws IOException {
        String whole = this.writeStream();
        int chunkSize = 16384;
        int chunks = whole.length() / chunkSize;
        if (whole.length() % chunkSize != 0) {
            ++chunks;
        }
        out.writeChar(1);
        out.write(new byte[]{0});
        out.writeInt(chunks);
        for (int c = 0; c < chunks; ++c) {
            String chunk = whole.substring(c * chunkSize, Math.min((c + 1) * chunkSize, whole.length()));
            out.writeUTF(chunk);
        }
    }

    public void readFieldsStream(String string) {
        Gson gson = DynamoDBUtil.getGson();
        String itemJson = this.fixMalformedJson(string);
        this.dynamoDBItem = (Map)gson.fromJson(itemJson, type);
    }

    public String writeStream() {
        Gson gson = DynamoDBUtil.getGson();
        return gson.toJson(this.dynamoDBItem, type);
    }

    public Map<String, AttributeValue> getItem() {
        return this.dynamoDBItem;
    }

    public void setItem(Map<String, AttributeValue> dynamoDBItem) {
        this.dynamoDBItem = dynamoDBItem;
    }

    public String toString() {
        return this.writeStream();
    }

    private String fixMalformedJson(String string) {
        if (!(string = string.trim()).startsWith("{")) {
            string = "{" + string + "}";
            string = string.replaceAll(START_OF_TEXT, ",");
            string = string.replaceAll(END_OF_TEXT, ":");
        }
        return string;
    }
}

