/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.key;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.key.AbstractDynamoDBKey;

public class DynamoDBBinaryKey
extends AbstractDynamoDBKey {
    private final ByteBuffer byteBuffer;

    public DynamoDBBinaryKey(String base64EncodedKey) {
        super(base64EncodedKey);
        this.byteBuffer = ByteBuffer.wrap(DynamoDBUtil.base64DecodeString(base64EncodedKey));
    }

    @Override
    public int compareValue(AttributeValue attribute) {
        return this.byteBuffer.compareTo(attribute.getB());
    }
}

