/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.RateController;
import org.apache.hadoop.dynamodb.preader.ScanRecordReadRequest;
import org.apache.hadoop.dynamodb.util.AbstractTimeSource;

public class ScanReadManager
extends AbstractReadManager {
    public ScanReadManager(RateController rateController, AbstractTimeSource time, DynamoDBRecordReaderContext context) {
        super(rateController, time, context);
    }

    @Override
    protected void initializeReadRequests() {
        ArrayList<Integer> shuffleSgments = new ArrayList<Integer>(this.context.getSplit().getSegments());
        if (shuffleSgments.isEmpty()) {
            String errorMsg = "0 segment. Need at least one segment to work with.";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        Collections.shuffle(shuffleSgments, new Random());
        this.segmentsRemaining.set(shuffleSgments.size());
        for (Integer segment : shuffleSgments) {
            this.enqueueReadRequestToTail(new ScanRecordReadRequest(this, this.context, segment, null));
        }
    }
}

