/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.split;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.split.DynamoDBSegmentsSplit;
import org.apache.hadoop.dynamodb.split.DynamoDBSplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class DynamoDBSplitGenerator {
    private static final Log log = LogFactory.getLog(DynamoDBSplitGenerator.class);

    public InputSplit[] generateSplits(int maxClusterMapTasks, int numSegments, JobConf conf) {
        log.info((Object)("Generating " + numSegments + " segments for " + maxClusterMapTasks + " max mappers"));
        int numMappers = Math.min(maxClusterMapTasks, numSegments);
        ArrayList segmentsPerSplit = new ArrayList(numMappers);
        for (int i = 0; i < numMappers; ++i) {
            segmentsPerSplit.add(new ArrayList());
        }
        int mapper = 0;
        for (int i = 0; i < numSegments; ++i) {
            ((List)segmentsPerSplit.get(mapper)).add(i);
            mapper = (mapper + 1) % numMappers;
        }
        long approxItemCountPerSplit = conf.getLong("dynamodb.item.count", 0L) / (long)numMappers;
        InputSplit[] splits = new InputSplit[numMappers];
        for (int i = 0; i < numMappers; ++i) {
            log.info((Object)("Assigning " + ((List)segmentsPerSplit.get(i)).size() + " segments to mapper " + i + ": " + segmentsPerSplit.get(i)));
            splits[i] = this.createDynamoDBSplit(this.getInputPath(conf), approxItemCountPerSplit, i, (List)segmentsPerSplit.get(i), numSegments);
        }
        return splits;
    }

    protected Path getInputPath(JobConf conf) {
        return null;
    }

    protected DynamoDBSplit createDynamoDBSplit(Path path, long approxItemCount, int splitId, List<Integer> segments, int totalSegments) {
        return new DynamoDBSegmentsSplit(path, approxItemCount, splitId, segments, totalSegments, null);
    }
}

