/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.type;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.dynamodb.type.DynamoDBBinarySetType;
import org.apache.hadoop.dynamodb.type.DynamoDBBinaryType;
import org.apache.hadoop.dynamodb.type.DynamoDBNumberSetType;
import org.apache.hadoop.dynamodb.type.DynamoDBNumberType;
import org.apache.hadoop.dynamodb.type.DynamoDBStringSetType;
import org.apache.hadoop.dynamodb.type.DynamoDBStringType;
import org.apache.hadoop.dynamodb.type.DynamoDBType;

public class DynamoDBTypeFactory {
    public static final DynamoDBType STRING_TYPE = new DynamoDBStringType();
    public static final DynamoDBType NUMBER_TYPE = new DynamoDBNumberType();
    public static final DynamoDBType BINARY_TYPE = new DynamoDBBinaryType();
    public static final DynamoDBType NUMBER_SET_TYPE = new DynamoDBNumberSetType();
    public static final DynamoDBType STRING_SET_TYPE = new DynamoDBStringSetType();
    public static final DynamoDBType BINARY_SET_TYPE = new DynamoDBBinarySetType();
    private static final Map<String, DynamoDBType> dynamoDBTypeMap = new HashMap<String, DynamoDBType>();

    public static DynamoDBType getTypeObjectFromDynamoDBType(String dynamoDBType) {
        return dynamoDBTypeMap.get(dynamoDBType);
    }

    static {
        dynamoDBTypeMap.put(STRING_TYPE.getDynamoDBType(), STRING_TYPE);
        dynamoDBTypeMap.put(NUMBER_TYPE.getDynamoDBType(), NUMBER_TYPE);
        dynamoDBTypeMap.put(BINARY_TYPE.getDynamoDBType(), BINARY_TYPE);
        dynamoDBTypeMap.put(NUMBER_SET_TYPE.getDynamoDBType(), NUMBER_SET_TYPE);
        dynamoDBTypeMap.put(STRING_SET_TYPE.getDynamoDBType(), STRING_SET_TYPE);
        dynamoDBTypeMap.put(BINARY_SET_TYPE.getDynamoDBType(), BINARY_SET_TYPE);
    }
}

