/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.read;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResultMultiplexer;
import org.apache.hadoop.dynamodb.preader.QueryReadManager;
import org.apache.hadoop.dynamodb.preader.RateController;
import org.apache.hadoop.dynamodb.preader.ScanReadManager;
import org.apache.hadoop.dynamodb.read.ReadIopsCalculator;
import org.apache.hadoop.dynamodb.split.DynamoDBSplit;
import org.apache.hadoop.dynamodb.util.TimeSource;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public abstract class AbstractDynamoDBRecordReader<K, V>
implements RecordReader<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDynamoDBRecordReader.class);
    protected final DynamoDBClient client;
    protected final String tableName;
    protected final DynamoDBSplit split;
    protected final long approxTotalItemCount;
    protected final Reporter reporter;
    private final PageResultMultiplexer<Map<String, AttributeValue>> pageMux;
    private final AbstractReadManager readMgr;
    private final DynamoDBRecordReaderContext context;
    protected volatile long readItemCount;

    public AbstractDynamoDBRecordReader(DynamoDBRecordReaderContext context) {
        this.context = context;
        this.client = context.getClient();
        this.tableName = context.getConf().get("dynamodb.input.tableName");
        this.split = context.getSplit();
        this.readItemCount = 0L;
        this.approxTotalItemCount = this.split.getApproxItemCount();
        this.reporter = context.getReporter();
        int numSegments = this.split.getSegments().size();
        if (numSegments != 1 && this.isQuery()) {
            throw new IllegalArgumentException("Query should always result in one segment");
        }
        this.pageMux = new PageResultMultiplexer(50, 600);
        this.context.setPageResultMultiplexer(this.pageMux);
        this.readMgr = this.initReadManager();
        this.printInitInfo();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public float getProgress() throws IOException {
        if (this.approxTotalItemCount == 0L) {
            return 0.0f;
        }
        float progress = (float)this.readItemCount / (float)this.approxTotalItemCount;
        return Math.min(progress, 0.9f);
    }

    public boolean next(K key, V value) throws IOException {
        this.reporter.progress();
        Map<String, AttributeValue> item = this.pageMux.next();
        if (item != null) {
            this.convertDynamoDBItemToValue(item, value);
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        log.info((Object)"Closing down record reader");
        this.readMgr.shutdown();
        this.client.close();
        this.pageMux.setDraining(true);
    }

    protected void convertDynamoDBItemToValue(Map<String, AttributeValue> item, V value) {
        DynamoDBItemWritable ddbItem = new DynamoDBItemWritable(item);
        this.convertDynamoDBItemToValue(ddbItem, value);
    }

    protected abstract void convertDynamoDBItemToValue(DynamoDBItemWritable var1, V var2);

    private AbstractReadManager initReadManager() {
        ReadIopsCalculator iopsCalculator = new ReadIopsCalculator(DynamoDBUtil.createJobClient(this.context.getConf()), this.client, this.tableName, this.split.getTotalSegments(), this.split.getSegments().size());
        double targetRate = iopsCalculator.calculateTargetIops();
        TimeSource time = new TimeSource();
        RateController rateController = new RateController(time, targetRate, 5, this.context.getAverageItemSize());
        if (this.isQuery()) {
            return new QueryReadManager(rateController, time, this.context);
        }
        return new ScanReadManager(rateController, time, this.context);
    }

    private boolean isQuery() {
        return this.split.getFilterPushdown().getKeyConditions().size() > 0;
    }

    private void printInitInfo() {
        log.info((Object)("Total segments: " + this.split.getTotalSegments()));
        log.info((Object)("Segment count of this mapper: " + this.split.getSegments().size()));
        log.info((Object)("Segments of this mapper: " + this.split.getSegments()));
        log.info((Object)("Approximate item count of this mapper: " + this.approxTotalItemCount));
    }
}

