/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.util;

import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.util.NodeCapacityProvider;
import org.apache.hadoop.mapred.JobConf;

public class ClusterTopologyNodeCapacityProvider
implements NodeCapacityProvider {
    private static final Log log = LogFactory.getLog(ClusterTopologyNodeCapacityProvider.class);
    private final JobConf conf;

    public ClusterTopologyNodeCapacityProvider(JobConf conf) {
        this.conf = conf;
    }

    @Override
    public int getCoreNodeMemoryMB() {
        boolean isCoreNodeSameInstanceTypeAsMaster = false;
        try {
            String jobFlowJsonString = this.readJobFlowJsonString();
            String masterInstanceType = this.extractInstanceType(jobFlowJsonString, "Master");
            String coreInstanceType = this.extractInstanceType(jobFlowJsonString, "Core");
            if (masterInstanceType != null && masterInstanceType.equals(coreInstanceType)) {
                isCoreNodeSameInstanceTypeAsMaster = true;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception when trying to determine instance types", (Throwable)e);
        }
        if (isCoreNodeSameInstanceTypeAsMaster) {
            return this.conf.getInt("yarn.nodemanager.resource.memory-mb", 8192);
        }
        return this.conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
    }

    String readJobFlowJsonString() throws IOException {
        return new String(Files.readAllBytes(Paths.get("/mnt/var/lib/info/job-flow.json", new String[0])));
    }

    private String extractInstanceType(String jobFlowJsonString, String targetInstanceRole) {
        JsonNode jobFlowJson = Jackson.jsonNodeOf((String)jobFlowJsonString);
        JsonNode instanceGroups = jobFlowJson.get("instanceGroups");
        for (int i = 0; i < instanceGroups.size(); ++i) {
            JsonNode instanceGroup = instanceGroups.get(i);
            String instanceRole = instanceGroup.get("instanceRole").asText();
            if (!targetInstanceRole.equalsIgnoreCase(instanceRole)) continue;
            String instanceType = instanceGroup.get("instanceType").asText();
            log.info((Object)(instanceRole + " instance type: " + instanceType));
            return instanceType;
        }
        return null;
    }
}

