/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.write;

import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.dynamodb.DynamoDBOperationType;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.IopsController;
import org.apache.hadoop.dynamodb.write.WriteIopsCalculator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class AbstractDynamoDBRecordWriter<K, V>
implements RecordWriter<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDynamoDBRecordWriter.class);
    private static final long PRINT_COUNT_INCREMENT = 1000L;
    private final DynamoDBClient client;
    private final Progressable progressable;
    private final String tableName;
    private IopsController iopsController;
    private long permissibleWritesPerSecond;
    private Reporter reporter;
    private int batchSize = 0;
    private long intervalBeginTime = 0L;
    private long nextPrintCount = 1000L;
    private long totalItemsWritten = 0L;
    private double totalIOPSConsumed = 0.0;
    private long writesPerSecond = 0L;
    private boolean deletionMode;

    public AbstractDynamoDBRecordWriter(JobConf jobConf, Progressable progressable) {
        this.progressable = progressable;
        this.client = new DynamoDBClient((Configuration)jobConf);
        this.tableName = jobConf.get("dynamodb.output.tableName");
        if (this.tableName == null) {
            throw new ResourceNotFoundException("No output table name was specified.");
        }
        this.deletionMode = jobConf.getBoolean("dynamodb.deletion.mode", false);
        WriteIopsCalculator iopsCalculator = new WriteIopsCalculator(DynamoDBUtil.createJobClient(jobConf), this.client, this.tableName);
        this.iopsController = new IopsController(iopsCalculator, 100.0, DynamoDBOperationType.WRITE);
        this.permissibleWritesPerSecond = this.iopsController.getTargetItemsPerSecond();
        log.info((Object)("Number of allocated item writes per second: " + this.permissibleWritesPerSecond));
        if (progressable instanceof Reporter) {
            this.reporter = (Reporter)progressable;
        }
    }

    public void write(K key, V value) throws IOException {
        if (value == null) {
            throw new RuntimeException("Null record encountered. At least the key columns must be specified.");
        }
        this.verifyInterval();
        if (this.progressable != null) {
            this.progressable.progress();
        }
        DynamoDBItemWritable item = this.convertValueToDynamoDBItem(key, value);
        BatchWriteItemResult result = this.client.putBatch(this.tableName, item.getItem(), this.permissibleWritesPerSecond - this.writesPerSecond, this.reporter, this.deletionMode);
        ++this.batchSize;
        ++this.totalItemsWritten;
        if (result != null) {
            if (result.getConsumedCapacity() != null) {
                for (ConsumedCapacity consumedCapacity : result.getConsumedCapacity()) {
                    double consumedUnits = consumedCapacity.getCapacityUnits();
                    this.totalIOPSConsumed += consumedUnits;
                }
            }
            int unprocessedItems = 0;
            for (List requests : result.getUnprocessedItems().values()) {
                unprocessedItems += requests.size();
            }
            this.writesPerSecond += (long)(this.batchSize - unprocessedItems);
            this.batchSize = unprocessedItems;
        }
    }

    public void close(Reporter reporter) throws IOException {
        this.client.close();
        log.info((Object)(this.totalItemsWritten + " total items written"));
    }

    protected abstract DynamoDBItemWritable convertValueToDynamoDBItem(K var1, V var2);

    private void verifyInterval() {
        if (this.writesPerSecond >= this.permissibleWritesPerSecond) {
            if (this.writesPerSecond > 0L) {
                this.iopsController.update(this.writesPerSecond, this.totalIOPSConsumed);
            }
            this.permissibleWritesPerSecond = this.iopsController.getTargetItemsPerSecond();
            if (this.totalItemsWritten > this.nextPrintCount) {
                log.info((Object)("Total items written: " + this.totalItemsWritten));
                log.info((Object)("New writes per second: " + this.permissibleWritesPerSecond));
                this.nextPrintCount += 1000L;
            }
            DynamoDBUtil.verifyInterval(this.intervalBeginTime, 1000L);
            this.intervalBeginTime = new DateTime(DateTimeZone.UTC).getMillis();
            this.totalIOPSConsumed = 0.0;
            this.writesPerSecond = 0L;
        }
    }
}

