/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.dynamodb.filter.DynamoDBQueryFilter;
import org.apache.hadoop.dynamodb.split.DynamoDBSplit;
import org.apache.hadoop.fs.Path;

public class DynamoDBSegmentsSplit
implements DynamoDBSplit {
    private long approxItemCount;
    private int splitId;
    private List<Integer> segments;
    private int totalSegments;
    private DynamoDBQueryFilter filterPushdown;

    public DynamoDBSegmentsSplit() {
        this.segments = new ArrayList<Integer>();
    }

    public DynamoDBSegmentsSplit(Path path, long approxItemCount, int splitId, List<Integer> segments, int totalSegments, DynamoDBQueryFilter filterPushdown) {
        this.approxItemCount = approxItemCount;
        this.segments = segments;
        this.splitId = splitId;
        this.totalSegments = totalSegments;
        this.filterPushdown = filterPushdown;
    }

    public long getLength() {
        return 0L;
    }

    public void readFields(DataInput in) throws IOException {
        this.approxItemCount = in.readLong();
        this.splitId = in.readInt();
        int numSegments = in.readInt();
        this.segments = new ArrayList<Integer>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            this.segments.add(in.readInt());
        }
        this.totalSegments = in.readInt();
        this.filterPushdown = new DynamoDBQueryFilter();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.approxItemCount);
        out.writeInt(this.splitId);
        out.writeInt(this.segments.size());
        for (Integer segment : this.segments) {
            out.writeInt(segment);
        }
        out.writeInt(this.totalSegments);
    }

    public String[] getLocations() throws IOException {
        return new String[0];
    }

    @Override
    public long getApproxItemCount() {
        return this.approxItemCount;
    }

    @Override
    public int getSplitId() {
        return this.splitId;
    }

    @Override
    public List<Integer> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    @Override
    public int getTotalSegments() {
        return this.totalSegments;
    }

    @Override
    public DynamoDBQueryFilter getFilterPushdown() {
        return this.filterPushdown;
    }

    @Override
    public void setDynamoDBFilterPushdown(DynamoDBQueryFilter filterPushdown) {
        this.filterPushdown = filterPushdown;
    }
}

