/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.write;

import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.IopsCalculator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class WriteIopsCalculator
implements IopsCalculator {
    private static final Log log = LogFactory.getLog(WriteIopsCalculator.class);
    private final DynamoDBClient dynamoDBClient;
    private final JobClient jobClient;
    private final JobConf jobConf;
    private final String tableName;
    private final int maxParallelTasks;
    private final double throughputPercent;

    public WriteIopsCalculator(JobClient jobClient, DynamoDBClient dynamoDBClient, String tableName) {
        this.jobConf = (JobConf)jobClient.getConf();
        this.jobClient = jobClient;
        this.dynamoDBClient = dynamoDBClient;
        this.tableName = tableName;
        this.throughputPercent = Double.parseDouble(this.jobConf.get("dynamodb.throughput.write.percent", "0.5"));
        log.info((Object)("Table name: " + tableName));
        log.info((Object)("Throughput percent: " + this.throughputPercent));
        String taskId = this.jobConf.get("mapreduce.task.attempt.id");
        log.info((Object)("Task Id: " + taskId));
        if (Strings.isNullOrEmpty((String)taskId)) {
            this.maxParallelTasks = 1;
        } else {
            int totalMapTasks = this.jobConf.getNumMapTasks();
            log.info((Object)("Total map tasks: " + totalMapTasks));
            this.maxParallelTasks = Math.min(this.calculateMaxMapTasks(totalMapTasks), totalMapTasks);
            log.info((Object)("Max parallel map tasks: " + this.maxParallelTasks));
        }
    }

    @Override
    public long calculateTargetIops() {
        double configuredThroughput = Math.floor(Double.parseDouble(this.jobConf.get("dynamodb.throughput.write", String.valueOf(this.getThroughput()))) * this.throughputPercent);
        long throughputPerTask = Math.max((long)(configuredThroughput / (double)this.maxParallelTasks), 1L);
        log.info((Object)("Throughput per task for table " + this.tableName + " : " + throughputPerTask));
        return throughputPerTask;
    }

    int calculateMaxMapTasks(int totalMapTasks) {
        try {
            return DynamoDBUtil.calcMaxMapTasks(this.jobClient);
        }
        catch (IOException e) {
            log.warn((Object)"Exception calculating max map tasks", (Throwable)e);
            return totalMapTasks;
        }
    }

    private double getThroughput() {
        TableDescription tableDescription = this.dynamoDBClient.describeTable(this.tableName);
        if (tableDescription.getBillingModeSummary() == null || tableDescription.getBillingModeSummary().getBillingMode().equalsIgnoreCase(DynamoDBConstants.BILLING_MODE_PROVISIONED)) {
            ProvisionedThroughputDescription provisionedThroughput = tableDescription.getProvisionedThroughput();
            return provisionedThroughput.getWriteCapacityUnits().longValue();
        }
        return DynamoDBConstants.DEFAULT_CAPACITY_FOR_ON_DEMAND.longValue();
    }
}

