/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.hive.dynamodb.DynamoDBSerDe;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBItemType;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class DynamoDBExportSerDe
extends DynamoDBSerDe {
    private static final Log log = LogFactory.getLog(DynamoDBExportSerDe.class);

    @Override
    public Object deserialize(Writable inputData) throws SerDeException {
        if (inputData == null) {
            return null;
        }
        if (inputData instanceof Text) {
            String data = inputData.toString();
            if (Strings.isNullOrEmpty((String)data)) {
                return null;
            }
            String collectionSplitCharacter = this.byteToString(1);
            List<String> fields = Arrays.asList(data.split(collectionSplitCharacter));
            if (fields.isEmpty()) {
                return null;
            }
            HashMap item = Maps.newHashMap();
            String mapSplitCharacter = this.byteToString(2);
            for (String field : fields) {
                if (Strings.isNullOrEmpty((String)field)) {
                    throw new SerDeException("Empty fields in data: " + data);
                }
                List<String> values = Arrays.asList(field.split(mapSplitCharacter));
                if (values.size() != 2) {
                    throw new SerDeException("Invalid record with map value: " + values);
                }
                String dynamoDBAttributeName = values.get(0);
                String dynamoDBAttributeValue = values.get(1);
                AttributeValue deserializedAttributeValue = HiveDynamoDBItemType.deserializeAttributeValue(dynamoDBAttributeValue);
                item.put(dynamoDBAttributeName, deserializedAttributeValue);
            }
            return new DynamoDBItemWritable((Map)item);
        }
        throw new SerDeException(((Object)((Object)this)).getClass().toString() + ": expects Text object!");
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException("The DynamoDBExportSerDe only supports deserializing data");
    }

    private String byteToString(int separatorIndex) {
        char[] charArray = new char[]{(char)this.serdeParams.getSeparators()[separatorIndex]};
        return new String(charArray);
    }
}

