/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBItemType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class DynamoDBObjectInspector
extends StructObjectInspector {
    private final List<String> columnNames;
    private List<StructField> structFields;
    private Map<String, DynamoDBField> columnNameStructFieldMap;

    DynamoDBObjectInspector(List<String> columnNames, List<TypeInfo> columnTypes, Map<String, String> columnMappings, Map<String, HiveDynamoDBType> typeMappings) {
        this.columnNames = columnNames;
        if (columnNames == null) {
            throw new RuntimeException("Null columns names passed");
        }
        if (columnTypes == null) {
            throw new RuntimeException("Null columns types passed");
        }
        this.structFields = Lists.newArrayList();
        this.columnNameStructFieldMap = Maps.newHashMap();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            DynamoDBField field = new DynamoDBField(i, columnName, columnMappings.get(columnName), columnTypes.get(i), typeMappings.get(columnName));
            this.structFields.add(field);
            this.columnNameStructFieldMap.put(columnName, field);
        }
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.structFields;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        DynamoDBItemWritable rowData = (DynamoDBItemWritable)data;
        return this.getColumnData(fieldRef, rowData);
    }

    private Object getColumnData(StructField fieldRef, DynamoDBItemWritable rowData) {
        try {
            DynamoDBField ddFieldRef = (DynamoDBField)fieldRef;
            ObjectInspector fieldOI = ddFieldRef.getFieldObjectInspector();
            HiveDynamoDBType ddType = ddFieldRef.getDynamoDBType();
            if (HiveDynamoDBTypeFactory.isHiveDynamoDBItemMapType(ddType)) {
                HiveDynamoDBItemType ddItemType = (HiveDynamoDBItemType)ddType;
                return ddItemType.buildHiveData(rowData.getItem());
            }
            String attributeName = ddFieldRef.getAttributeName();
            if (rowData.getItem().containsKey(attributeName)) {
                AttributeValue fieldValue = (AttributeValue)rowData.getItem().get(attributeName);
                return fieldValue == null ? null : ddType.getHiveData(fieldValue, fieldOI);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while processing record: " + rowData.toString(), e);
        }
    }

    public StructField getStructFieldRef(String columnName) {
        return this.columnNameStructFieldMap.get(columnName);
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        DynamoDBItemWritable rowData = (DynamoDBItemWritable)data;
        ArrayList<Object> columnData = new ArrayList<Object>();
        for (String columnName : this.columnNames) {
            columnData.add(this.getColumnData(this.columnNameStructFieldMap.get(columnName), rowData));
        }
        return columnData;
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public String getTypeName() {
        return "struct";
    }

    private static class DynamoDBField
    implements StructField {
        private final int fieldID;
        private final String fieldName;
        private final String attributeName;
        private final ObjectInspector objectInspector;
        private final HiveDynamoDBType ddType;

        DynamoDBField(int fieldID, String fieldName, String attributeName, TypeInfo typeInfo, HiveDynamoDBType ddType) {
            this.fieldID = fieldID;
            this.fieldName = fieldName;
            this.attributeName = attributeName;
            this.objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
            this.ddType = ddType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.objectInspector;
        }

        public String getFieldComment() {
            return null;
        }

        public int getFieldID() {
            return this.fieldID;
        }

        String getAttributeName() {
            return this.attributeName;
        }

        HiveDynamoDBType getDynamoDBType() {
            return this.ddType;
        }
    }
}

