/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BillingModeSummary;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.hive.dynamodb.DynamoDBObjectInspector;
import org.apache.hadoop.hive.dynamodb.shims.SerDeParametersShim;
import org.apache.hadoop.hive.dynamodb.shims.ShimsLoader;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBItemType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.dynamodb.util.DynamoDBDataParser;
import org.apache.hadoop.hive.dynamodb.util.HiveDynamoDBUtil;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class DynamoDBSerDe
extends AbstractSerDe {
    private static final Log log = LogFactory.getLog(DynamoDBSerDe.class);
    private static boolean warningPrinted;
    protected SerDeParametersShim serdeParams;
    private DynamoDBObjectInspector objectInspector;
    private Map<String, String> columnMappings;
    private Map<String, HiveDynamoDBType> typeMappings;
    private boolean nullSerialization;
    private List<String> columnNames;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.serdeParams = ShimsLoader.getHiveShims().getSerDeParametersShim(conf, tbl, ((Object)((Object)this)).getClass().getName());
        this.columnNames = this.serdeParams.getColumnNames();
        List columnTypes = this.serdeParams.getColumnTypes();
        this.columnMappings = HiveDynamoDBUtil.getHiveToDynamoDBColumnMapping(tbl);
        log.info((Object)("Column mapping: " + this.columnMappings));
        this.typeMappings = HiveDynamoDBUtil.getHiveToDynamoDBTypeMapping(this.columnNames, columnTypes, tbl);
        log.info((Object)("Type mapping: " + this.typeMappings));
        this.nullSerialization = HiveDynamoDBUtil.getHiveToDynamoDBNullSerialization(tbl);
        log.info((Object)("Null serialization: " + this.nullSerialization));
        this.objectInspector = new DynamoDBObjectInspector(this.columnNames, columnTypes, this.columnMappings, this.typeMappings);
        this.verifyDynamoDBWriteThroughput(conf, tbl);
    }

    public Object deserialize(Writable dataMap) throws SerDeException {
        if (!(dataMap instanceof DynamoDBItemWritable)) {
            throw new SerDeException("Expected DynamoDBMapWritable data type, got " + dataMap.getClass().getName() + " data: " + dataMap.toString());
        }
        return dataMap;
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List rowData = soi.getStructFieldsDataAsList(obj);
        HashMap item = Maps.newHashMap();
        this.validateData(fields, rowData);
        for (int i = 0; i < fields.size(); ++i) {
            AttributeValue attributeValue;
            StructField field = (StructField)fields.get(i);
            Object data = rowData.get(i);
            String columnName = this.columnNames.get(i);
            ObjectInspector fieldOI = field.getFieldObjectInspector();
            HiveDynamoDBType ddType = this.typeMappings.get(columnName);
            if (HiveDynamoDBTypeFactory.isHiveDynamoDBItemMapType(ddType)) {
                HiveDynamoDBItemType ddItemType = (HiveDynamoDBItemType)ddType;
                Map<String, AttributeValue> backupItem = ddItemType.parseDynamoDBData(data, fieldOI);
                for (Map.Entry<String, AttributeValue> entry : backupItem.entrySet()) {
                    if (this.columnMappings.containsValue(entry.getKey())) continue;
                    item.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            AttributeValue attributeValue2 = attributeValue = data == null ? DynamoDBDataParser.getNullAttribute(this.nullSerialization) : ddType.getDynamoDBData(data, fieldOI, this.nullSerialization);
            if (attributeValue == null) continue;
            item.put(this.columnMappings.get(columnName), attributeValue);
        }
        return new DynamoDBItemWritable((Map)item);
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    private void validateData(List<? extends StructField> fields, List<Object> rowData) {
        if (rowData == null) {
            throw new RuntimeException("No data found in the row.");
        }
        if (fields == null) {
            throw new RuntimeException("Field information not available");
        }
        if (rowData.size() != fields.size()) {
            throw new RuntimeException("Number of data objects do not match number of columns. Data: " + rowData);
        }
    }

    private void verifyDynamoDBWriteThroughput(Configuration conf, Properties tbl) {
        long maxMapTasks;
        if (conf == null) {
            return;
        }
        if (warningPrinted) {
            return;
        }
        String dynamoDBTableName = tbl.getProperty("dynamodb.table.name");
        if (dynamoDBTableName == null) {
            return;
        }
        log.info((Object)("Table Properties:" + tbl));
        DynamoDBClient client = new DynamoDBClient(conf, tbl.getProperty("dynamodb.region"));
        long writesPerSecond = client.describeTable(dynamoDBTableName).getProvisionedThroughput().getWriteCapacityUnits();
        try {
            JobClient jc = new JobClient(new JobConf(conf));
            maxMapTasks = jc.getClusterStatus().getMaxMapTasks();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get cluster capacity.", e);
        }
        BillingModeSummary billingModeSummary = client.describeTable(dynamoDBTableName).getBillingModeSummary();
        if (maxMapTasks > writesPerSecond && (billingModeSummary == null || billingModeSummary.getBillingMode().equals(DynamoDBConstants.BILLING_MODE_PROVISIONED))) {
            String message = "WARNING: Configured write throughput of the dynamodb table " + dynamoDBTableName + " is less than the cluster map capacity. ClusterMapCapacity: " + maxMapTasks + " WriteThroughput: " + writesPerSecond + "\nWARNING: Writes to this table might result in a write outage on the table.";
            SessionState.LogHelper console = SessionState.getConsole();
            if (console != null) {
                console.printInfo(message);
            }
            log.warn((Object)message);
            warningPrinted = true;
        }
    }
}

