/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.hive.dynamodb.DynamoDBSerDe;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBFilterPushdown;
import org.apache.hadoop.hive.dynamodb.read.HiveDynamoDBInputFormat;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.dynamodb.util.HiveDynamoDBUtil;
import org.apache.hadoop.hive.dynamodb.write.HiveDynamoDBOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;

public class DynamoDBStorageHandler
implements HiveMetaHook,
HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final Log log = LogFactory.getLog(DynamoDBStorageHandler.class);
    private Configuration conf;

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTable(Table table) throws MetaException {
        try (DynamoDBClient client = this.createDynamoDBClient(table);){
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
            if (!isExternal) {
                throw new MetaException("Only EXTERNAL tables are supported for DynamoDB.");
            }
            String tableName = HiveDynamoDBUtil.getDynamoDBTableName((String)table.getParameters().get("dynamodb.table.name"), table.getTableName());
            TableDescription tableDescription = client.describeTable(tableName);
            this.checkTableStatus(tableDescription);
            this.checkTableSchemaMapping(tableDescription, table);
            this.checkTableSchemaType(tableDescription, table);
        }
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackCreateTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        if (jobConf.getBoolean("dynamodb.filter.pushdown", true)) {
            return new DynamoDBFilterPushdown().pushPredicate(HiveDynamoDBUtil.extractHiveTypeMapping(jobConf), predicate);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try (DynamoDBClient client = new DynamoDBClient(this.conf, tableDesc.getProperties().getProperty("dynamodb.region"));){
            String tableName = HiveDynamoDBUtil.getDynamoDBTableName(tableDesc.getProperties().getProperty("dynamodb.table.name"), tableDesc.getTableName());
            TableDescription description = client.describeTable(tableName);
            Double averageItemSize = DynamoDBUtil.calculateAverageItemSize((TableDescription)description);
            log.info((Object)("Average item size: " + averageItemSize));
            String endpoint = this.conf.get("dynamodb.endpoint");
            if (!Strings.isNullOrEmpty((String)tableDesc.getProperties().getProperty("dynamodb.endpoint"))) {
                endpoint = tableDesc.getProperties().getProperty("dynamodb.endpoint");
            }
            if (!Strings.isNullOrEmpty((String)endpoint)) {
                jobProperties.put("dynamodb.endpoint", endpoint);
            }
            if (!Strings.isNullOrEmpty((String)tableDesc.getProperties().getProperty("dynamodb.region"))) {
                jobProperties.put("dynamodb.region", tableDesc.getProperties().getProperty("dynamodb.region"));
            }
            jobProperties.put("dynamodb.output.tableName", tableName);
            jobProperties.put("dynamodb.input.tableName", tableName);
            jobProperties.put("dynamodb.table.name", tableName);
            Map<String, String> hiveToDynamoDBSchemaMapping = HiveDynamoDBUtil.getHiveToDynamoDBMapping(tableDesc.getProperties().getProperty("dynamodb.column.mapping"));
            if (hiveToDynamoDBSchemaMapping != null) {
                jobProperties.put("dynamodb.column.mapping", HiveDynamoDBUtil.toJsonString(hiveToDynamoDBSchemaMapping));
            }
            Map<String, String> hiveToDynamoDBTypeMapping = HiveDynamoDBUtil.getHiveToDynamoDBMapping(tableDesc.getProperties().getProperty("dynamodb.type.mapping"));
            if (hiveToDynamoDBSchemaMapping != null) {
                jobProperties.put("dynamodb.type.mapping", HiveDynamoDBUtil.toJsonString(hiveToDynamoDBTypeMapping));
            }
            boolean hiveToDynamoDBNullSerialization = Boolean.parseBoolean(tableDesc.getProperties().getProperty("dynamodb.null.serialization"));
            jobProperties.put("dynamodb.null.serialization", Boolean.toString(hiveToDynamoDBNullSerialization));
            if (tableDesc.getProperties().getProperty("dynamodb.throughput.read.percent") != null) {
                jobProperties.put("dynamodb.throughput.read.percent", tableDesc.getProperties().getProperty("dynamodb.throughput.read.percent"));
            }
            if (tableDesc.getProperties().getProperty("dynamodb.throughput.write.percent") != null) {
                jobProperties.put("dynamodb.throughput.write.percent", tableDesc.getProperties().getProperty("dynamodb.throughput.write.percent"));
            }
            if (description.getBillingModeSummary() == null || description.getBillingModeSummary().getBillingMode().equals(DynamoDBConstants.BILLING_MODE_PROVISIONED)) {
                this.useExplicitThroughputIfRequired(jobProperties, tableDesc);
            } else {
                jobProperties.put("dynamodb.throughput.read", tableDesc.getProperties().getProperty("dynamodb.throughput.read", DynamoDBConstants.DEFAULT_CAPACITY_FOR_ON_DEMAND.toString()));
                jobProperties.put("dynamodb.throughput.write", tableDesc.getProperties().getProperty("dynamodb.throughput.write", DynamoDBConstants.DEFAULT_CAPACITY_FOR_ON_DEMAND.toString()));
            }
            jobProperties.put("dynamodb.item.count", description.getItemCount().toString());
            jobProperties.put("dynamodb.table.size-bytes", description.getTableSizeBytes().toString());
            jobProperties.put("dynamodb.item.average.size", averageItemSize.toString());
            log.info((Object)("Average item size: " + averageItemSize));
            log.info((Object)("Item count: " + description.getItemCount()));
            log.info((Object)("Table size: " + description.getTableSizeBytes()));
            log.info((Object)("Read throughput: " + jobProperties.get("dynamodb.throughput.read")));
            log.info((Object)("Write throughput: " + jobProperties.get("dynamodb.throughput.write")));
        }
    }

    private void useExplicitThroughputIfRequired(Map<String, String> jobProperties, TableDesc tableDesc) {
        String userRequiredWriteThroughput;
        String userRequiredReadThroughput = tableDesc.getProperties().getProperty("dynamodb.throughput.read");
        if (userRequiredReadThroughput != null) {
            jobProperties.put("dynamodb.throughput.read", userRequiredReadThroughput);
        }
        if ((userRequiredWriteThroughput = tableDesc.getProperties().getProperty("dynamodb.throughput.write")) != null) {
            jobProperties.put("dynamodb.throughput.write", userRequiredWriteThroughput);
        }
    }

    public Class<? extends InputFormat<Text, DynamoDBItemWritable>> getInputFormatClass() {
        return HiveDynamoDBInputFormat.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public Class<? extends OutputFormat<Text, DynamoDBItemWritable>> getOutputFormatClass() {
        return HiveDynamoDBOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return DynamoDBSerDe.class;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureTableJobProperties(tableDesc, jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureTableJobProperties(tableDesc, jobProperties);
    }

    void checkTableSchemaMapping(TableDescription tableDescription, Table table) throws MetaException {
        String mapping = (String)table.getParameters().get("dynamodb.column.mapping");
        Map<String, String> columnMapping = HiveDynamoDBUtil.getHiveToDynamoDBMapping(mapping);
        List tableSchema = table.getSd().getCols();
        for (FieldSchema fieldSchema : tableSchema) {
            String fieldSchemaName = fieldSchema.getName().toLowerCase();
            if (HiveDynamoDBTypeFactory.isHiveDynamoDBItemMapType(fieldSchema.getType())) {
                columnMapping.remove(fieldSchemaName);
                continue;
            }
            if (columnMapping.containsKey(fieldSchemaName)) {
                if (columnMapping.get(fieldSchemaName).isEmpty()) {
                    throw new MetaException("Invalid column mapping for column: " + fieldSchemaName);
                }
                columnMapping.remove(fieldSchemaName);
                continue;
            }
            throw new MetaException("Could not find column mapping for column: " + fieldSchemaName);
        }
        if (!columnMapping.isEmpty()) {
            StringBuilder exMessage = new StringBuilder("Could not find column(s) for column mapping(s): ");
            String delim = "";
            for (String extraMapping : columnMapping.keySet()) {
                exMessage.append(delim + extraMapping + ":" + columnMapping.get(extraMapping));
                delim = ",";
            }
            throw new MetaException(exMessage.toString());
        }
    }

    void checkTableSchemaType(TableDescription tableDescription, Table table) throws MetaException {
        List tableSchema = table.getSd().getCols();
        String mapping = (String)table.getParameters().get("dynamodb.type.mapping");
        Map<String, String> typeMapping = HiveDynamoDBUtil.getHiveToDynamoDBMapping(mapping);
        boolean hasItemMapType = false;
        for (FieldSchema fieldSchema : tableSchema) {
            HiveDynamoDBType ddType;
            String fieldName = fieldSchema.getName();
            String fieldType = fieldSchema.getType();
            if (typeMapping.containsKey(fieldName)) {
                try {
                    ddType = HiveDynamoDBTypeFactory.getTypeObjectFromDynamoDBType(typeMapping.get(fieldName));
                }
                catch (IllegalArgumentException e) {
                    throw new MetaException("The DynamoDB type " + typeMapping.get(fieldName) + " is not supported");
                }
                if (!ddType.supportsHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)fieldType))) {
                    throw new MetaException("The DynamoDB type " + typeMapping.get(fieldName) + " does not support Hive type " + fieldType);
                }
            } else {
                try {
                    ddType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(fieldType);
                }
                catch (IllegalArgumentException e) {
                    throw new MetaException("The hive type " + fieldSchema.getType() + " is not supported in DynamoDB");
                }
            }
            if (HiveDynamoDBTypeFactory.isHiveDynamoDBItemMapType(ddType)) {
                if (hasItemMapType) {
                    throw new MetaException("Only one column can be mapped to item map type " + fieldType);
                }
                hasItemMapType = true;
            }
            for (AttributeDefinition definition : tableDescription.getAttributeDefinitions()) {
                String attributeName = definition.getAttributeName();
                if (!fieldName.equalsIgnoreCase(attributeName)) continue;
                String attributeType = definition.getAttributeType();
                if (!HiveDynamoDBTypeFactory.isHiveDynamoDBItemMapType(ddType) && ddType.getDynamoDBType().equals(attributeType)) continue;
                throw new MetaException("The key element " + fieldName + " does not match type. DynamoDB Type: " + attributeType + " Hive type: " + fieldType);
            }
        }
    }

    private DynamoDBClient createDynamoDBClient(Table table) {
        String region = (String)table.getParameters().get("dynamodb.region");
        return new DynamoDBClient(this.conf, region);
    }

    private void checkTableStatus(TableDescription tableDescription) throws MetaException {
        String status = tableDescription.getTableStatus();
        if ("CREATING".equals(status) || "DELETING".equals(status)) {
            throw new MetaException("Table " + tableDescription.getTableName() + " is in state " + status);
        }
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        this.configureTableJobProperties(tableDesc, jobProperties);
        for (Map.Entry entry : jobProperties.entrySet()) {
            jobConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

