/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.filter;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import java.util.ArrayList;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilterOperator;
import org.apache.hadoop.hive.dynamodb.filter.AbstractDynamoDBFilter;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;

public class DynamoDBBinaryFilter
extends AbstractDynamoDBFilter {
    private final String columnValue;

    public DynamoDBBinaryFilter(String columnName, DynamoDBFilterOperator operator, String columnType, String columnValue) {
        super(columnName, operator, columnType);
        this.columnValue = columnValue;
    }

    @Override
    public Condition createCondition() {
        Condition condition = new Condition();
        condition.setComparisonOperator(this.operator.getDynamoDBName());
        ArrayList<AttributeValue> attributeValueList = new ArrayList<AttributeValue>();
        attributeValueList.add(HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(this.columnType).getAttributeValue(new String[]{this.columnValue}));
        condition.setAttributeValueList(attributeValueList);
        return condition;
    }

    public String getColumnValue() {
        return this.columnValue;
    }
}

