/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.filter;

import java.util.List;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilter;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilterOperator;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBBinaryFilter;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBNAryFilter;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBUnaryFilter;
import org.apache.hadoop.hive.dynamodb.shims.ShimsLoader;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;

public class DynamoDBFilterFactory {
    public DynamoDBFilter getFilter(DynamoDBFilterOperator operator, String columnName, String columnType, String ... values) {
        switch (operator.getType()) {
            case UNARY: {
                return new DynamoDBUnaryFilter(columnName, operator, columnType);
            }
            case BINARY: {
                return new DynamoDBBinaryFilter(columnName, operator, columnType, values[0]);
            }
            case NARY: {
                return new DynamoDBNAryFilter(columnName, operator, columnType, values);
            }
        }
        throw new RuntimeException("Unknown operator type. Operator: " + operator + " OperatorType: " + operator.getType());
    }

    public DynamoDBFilter getFilter(DynamoDBFilterOperator operator, String columnName, String columnType, IndexSearchCondition condition) {
        switch (operator.getType()) {
            case UNARY: {
                return this.getFilter(operator, columnName, columnType, new String[0]);
            }
            case BINARY: {
                return this.getFilter(operator, columnName, columnType, condition.getConstantDesc().getValue().toString());
            }
            case NARY: {
                List children = ShimsLoader.getHiveShims().getIndexExpression(condition).getChildren();
                String[] values = new String[children.size() - 1];
                for (int i = 1; i < children.size(); ++i) {
                    values[i - 1] = ((ExprNodeConstantDesc)children.get(i)).getValue().toString();
                }
                return this.getFilter(operator, columnName, columnType, values);
            }
        }
        throw new RuntimeException("Unknown operator type. Operator: " + operator + " OperatorType: " + operator.getType());
    }
}

