/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.filter;

import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilter;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilterOperator;
import org.apache.hadoop.dynamodb.filter.DynamoDBIndexInfo;
import org.apache.hadoop.dynamodb.filter.DynamoDBQueryFilter;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBBinaryFilter;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBFilterFactory;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

public class DynamoDBFilterPushdown {
    private static final Log log = LogFactory.getLog(DynamoDBFilterPushdown.class);
    private final Set<String> eligibleHiveTypes = new HashSet<String>();
    private final Set<DynamoDBFilterOperator> eligibleOperatorsForRange = new HashSet<DynamoDBFilterOperator>();
    private final IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
    private static final int HASH_KEY_INDEX = 0;
    private static final int RANGE_KEY_INDEX = 1;
    private static final String DYNAMODB_KEY_TYPE_HASH = "HASH";

    public DynamoDBFilterPushdown() {
        this.eligibleHiveTypes.add("double");
        this.eligibleHiveTypes.add("bigint");
        this.eligibleHiveTypes.add("string");
        this.eligibleHiveTypes.add("binary");
        this.eligibleOperatorsForRange.add(DynamoDBFilterOperator.EQ);
        this.eligibleOperatorsForRange.add(DynamoDBFilterOperator.LE);
        this.eligibleOperatorsForRange.add(DynamoDBFilterOperator.LT);
        this.eligibleOperatorsForRange.add(DynamoDBFilterOperator.GE);
        this.eligibleOperatorsForRange.add(DynamoDBFilterOperator.GT);
        this.eligibleOperatorsForRange.add(DynamoDBFilterOperator.BETWEEN);
    }

    public HiveStoragePredicateHandler.DecomposedPredicate pushPredicate(Map<String, String> hiveTypeMapping, ExprNodeDesc predicate) {
        log.info((Object)"Checking predicates for pushdown in DynamoDB query");
        List<IndexSearchCondition> searchConditions = this.getGenericSearchConditions(hiveTypeMapping, predicate);
        log.info((Object)("Pushed predicates: " + searchConditions));
        if (searchConditions.isEmpty()) {
            return null;
        }
        List<IndexSearchCondition> finalSearchCondition = this.prioritizeSearchConditions(searchConditions);
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = this.analyzer.translateSearchConditions(finalSearchCondition);
        decomposedPredicate.residualPredicate = (ExprNodeGenericFuncDesc)predicate;
        return decomposedPredicate;
    }

    public DynamoDBQueryFilter predicateToDynamoDBFilter(List<KeySchemaElement> schema, List<LocalSecondaryIndexDescription> localSecondaryIndexes, List<GlobalSecondaryIndexDescription> globalSecondaryIndexes, Map<String, String> hiveDynamoDBMapping, Map<String, String> hiveTypeMapping, ExprNodeDesc predicate) {
        List<IndexSearchCondition> searchConditions = this.getGenericSearchConditions(hiveTypeMapping, predicate);
        if (searchConditions.isEmpty()) {
            return null;
        }
        HashMap<String, DynamoDBFilter> filterMap = new HashMap<String, DynamoDBFilter>();
        DynamoDBFilterFactory factory = new DynamoDBFilterFactory();
        for (IndexSearchCondition condition : searchConditions) {
            String hiveColumnName = condition.getColumnDesc().getColumn();
            String dynamoDBColumnName = hiveDynamoDBMapping.get(hiveColumnName);
            DynamoDBFilterOperator op = DynamoDBFilterOperator.getFilterOperationFromHiveClass((String)condition.getComparisonOp());
            DynamoDBFilter filter = factory.getFilter(op, dynamoDBColumnName, hiveTypeMapping.get(hiveColumnName), condition);
            if (filterMap.containsKey(dynamoDBColumnName)) {
                DynamoDBFilter existingFilter = (DynamoDBFilter)filterMap.get(dynamoDBColumnName);
                if (this.isBetweenFilter(op, existingFilter.getOperator())) {
                    filterMap.put(dynamoDBColumnName, this.getBetweenFilter(filter, existingFilter));
                    continue;
                }
                throw new RuntimeException("Found two filters for same column: " + dynamoDBColumnName + " Filter 1: " + op + " Filter 2: " + existingFilter.getOperator());
            }
            filterMap.put(dynamoDBColumnName, filter);
        }
        return this.getDynamoDBQueryFilter(schema, localSecondaryIndexes, globalSecondaryIndexes, hiveDynamoDBMapping, filterMap);
    }

    private boolean isBetweenFilter(DynamoDBFilterOperator op1, DynamoDBFilterOperator op2) {
        if (op1.equals((Object)DynamoDBFilterOperator.GE) && op2.equals((Object)DynamoDBFilterOperator.LE)) {
            return true;
        }
        return op2.equals((Object)DynamoDBFilterOperator.GE) && op1.equals((Object)DynamoDBFilterOperator.LE);
    }

    private DynamoDBFilter getBetweenFilter(DynamoDBFilter filter1, DynamoDBFilter filter2) {
        String val2;
        String val1;
        if (filter1.getOperator().equals((Object)DynamoDBFilterOperator.GE)) {
            val1 = ((DynamoDBBinaryFilter)filter1).getColumnValue();
            val2 = ((DynamoDBBinaryFilter)filter2).getColumnValue();
        } else {
            val1 = ((DynamoDBBinaryFilter)filter2).getColumnValue();
            val2 = ((DynamoDBBinaryFilter)filter1).getColumnValue();
        }
        return new DynamoDBFilterFactory().getFilter(DynamoDBFilterOperator.BETWEEN, filter1.getColumnName(), filter1.getColumnType(), val1, val2);
    }

    private List<IndexSearchCondition> getGenericSearchConditions(Map<String, String> hiveTypeMapping, ExprNodeDesc predicate) {
        this.analyzer.clearAllowedColumnNames();
        for (Map.Entry<String, String> entry : hiveTypeMapping.entrySet()) {
            if (!this.eligibleHiveTypes.contains(entry.getValue())) continue;
            this.analyzer.allowColumnName(entry.getKey());
        }
        for (DynamoDBFilterOperator op : DynamoDBFilterOperator.values()) {
            if (op.getHiveClass() == null) continue;
            this.analyzer.addComparisonOp(op.getHiveClass());
        }
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>();
        this.analyzer.analyzePredicate(predicate, searchConditions);
        return searchConditions;
    }

    private List<IndexSearchCondition> prioritizeSearchConditions(List<IndexSearchCondition> searchConditions) {
        HashMap<String, IndexSearchCondition> priorityFilterMap = new HashMap<String, IndexSearchCondition>();
        HashMap completeFilterMap = new HashMap();
        for (IndexSearchCondition condition : searchConditions) {
            String name = condition.getColumnDesc().getColumn();
            DynamoDBFilterOperator op = DynamoDBFilterOperator.getFilterOperationFromHiveClass((String)condition.getComparisonOp());
            if (priorityFilterMap.containsKey(name)) {
                if (DynamoDBFilterOperator.getFilterOperationFromHiveClass((String)((IndexSearchCondition)priorityFilterMap.get(name)).getComparisonOp()).isLowerPrecedence(op)) {
                    priorityFilterMap.put(name, condition);
                }
            } else {
                completeFilterMap.put(name, new ArrayList());
                priorityFilterMap.put(name, condition);
            }
            ((List)completeFilterMap.get(name)).add(condition);
        }
        ArrayList<IndexSearchCondition> finalSearchConditions = new ArrayList<IndexSearchCondition>();
        finalSearchConditions.addAll(priorityFilterMap.values());
        for (Map.Entry entry : completeFilterMap.entrySet()) {
            for (IndexSearchCondition condition : (List)entry.getValue()) {
                DynamoDBFilterOperator op2;
                DynamoDBFilterOperator op1 = DynamoDBFilterOperator.getFilterOperationFromHiveClass((String)condition.getComparisonOp());
                if (!this.isBetweenFilter(op1, op2 = DynamoDBFilterOperator.getFilterOperationFromHiveClass((String)((IndexSearchCondition)priorityFilterMap.get(entry.getKey())).getComparisonOp()))) continue;
                finalSearchConditions.add(condition);
            }
        }
        return finalSearchConditions;
    }

    private DynamoDBQueryFilter getDynamoDBQueryFilter(List<KeySchemaElement> schema, List<LocalSecondaryIndexDescription> localSecondaryIndexes, List<GlobalSecondaryIndexDescription> globalSecondaryIndexes, Map<String, String> hiveDynamoDBMapping, Map<String, DynamoDBFilter> filterMap) {
        DynamoDBQueryFilter filter = new DynamoDBQueryFilter();
        List<DynamoDBFilter> keyFiltersUseForQuery = this.getDynamoDBFiltersFromSchema(schema, filterMap);
        DynamoDBIndexInfo indexUseForQuery = null;
        if (keyFiltersUseForQuery.size() < schema.size()) {
            if (keyFiltersUseForQuery.size() == 0 && globalSecondaryIndexes != null) {
                indexUseForQuery = this.getIndexUseForQuery(schema, globalSecondaryIndexes.stream().map(index -> new DynamoDBIndexInfo(index.getIndexName(), index.getKeySchema(), index.getProjection())).collect(Collectors.toList()), hiveDynamoDBMapping, filterMap, keyFiltersUseForQuery);
                if (indexUseForQuery != null && indexUseForQuery.getIndexSchema().size() > keyFiltersUseForQuery.size()) {
                    indexUseForQuery = null;
                    keyFiltersUseForQuery.clear();
                }
            } else if (keyFiltersUseForQuery.size() == 1 && localSecondaryIndexes != null) {
                indexUseForQuery = this.getIndexUseForQuery(schema, localSecondaryIndexes.stream().map(index -> new DynamoDBIndexInfo(index.getIndexName(), index.getKeySchema(), index.getProjection())).collect(Collectors.toList()), hiveDynamoDBMapping, filterMap, keyFiltersUseForQuery);
            }
        }
        if (indexUseForQuery != null) {
            log.info((Object)("Setting index name used for query: " + indexUseForQuery.getIndexName()));
            filter.setIndex(indexUseForQuery);
        }
        for (DynamoDBFilter f : keyFiltersUseForQuery) {
            filter.addKeyCondition(f);
        }
        for (DynamoDBFilter f : filterMap.values()) {
            if (filter.getKeyConditions().containsKey(f.getColumnName())) continue;
            filter.addScanFilter(f);
        }
        return filter;
    }

    private DynamoDBIndexInfo getIndexUseForQuery(List<KeySchemaElement> tableSchema, List<DynamoDBIndexInfo> indexes, Map<String, String> hiveDynamoDBMapping, Map<String, DynamoDBFilter> filterMap, List<DynamoDBFilter> keyFiltersUseForQuery) {
        DynamoDBIndexInfo indexUseForQuery = null;
        for (DynamoDBIndexInfo index : indexes) {
            List<DynamoDBFilter> indexFilterList = this.getDynamoDBFiltersFromSchema(index.getIndexSchema(), filterMap);
            if (indexFilterList.size() <= keyFiltersUseForQuery.size() || !this.indexIncludesAllMappedAttributes(tableSchema, index, hiveDynamoDBMapping)) continue;
            keyFiltersUseForQuery.clear();
            keyFiltersUseForQuery.addAll(indexFilterList);
            indexUseForQuery = index;
            if (keyFiltersUseForQuery.size() != 2) continue;
            break;
        }
        return indexUseForQuery;
    }

    private boolean indexIncludesAllMappedAttributes(List<KeySchemaElement> tableSchema, DynamoDBIndexInfo index, Map<String, String> hiveDynamoDBMapping) {
        Projection indexProjection = index.getIndexProjection();
        if (ProjectionType.ALL.toString().equals(indexProjection.getProjectionType())) {
            return true;
        }
        HashSet<String> projectionAttributes = new HashSet<String>();
        for (KeySchemaElement keySchemaElement : tableSchema) {
            projectionAttributes.add(keySchemaElement.getAttributeName());
        }
        for (KeySchemaElement keySchemaElement : index.getIndexSchema()) {
            projectionAttributes.add(keySchemaElement.getAttributeName());
        }
        if (ProjectionType.INCLUDE.toString().equals(indexProjection.getProjectionType())) {
            projectionAttributes.addAll(indexProjection.getNonKeyAttributes());
        }
        log.info((Object)("Checking if all mapped attributes " + hiveDynamoDBMapping.values() + " are included in the index " + index.getIndexName() + " having attributes " + projectionAttributes));
        for (String queriedAttribute : hiveDynamoDBMapping.values()) {
            if (projectionAttributes.contains(queriedAttribute)) continue;
            log.info((Object)("Not all mapped attributes are included in the index. Won't use index: " + index.getIndexName()));
            return false;
        }
        return true;
    }

    private List<DynamoDBFilter> getDynamoDBFiltersFromSchema(List<KeySchemaElement> schema, Map<String, DynamoDBFilter> filterMap) {
        DynamoDBFilter rangeKeyFilter;
        String rangeKeyName;
        DynamoDBFilter hashKeyFilter;
        String hashKeyName;
        ArrayList<DynamoDBFilter> dynamoDBFilters = new ArrayList<DynamoDBFilter>();
        boolean hashKeyFilterExists = false;
        if (schema.size() > 0 && DYNAMODB_KEY_TYPE_HASH.equals(schema.get(0).getKeyType()) && filterMap.containsKey(hashKeyName = schema.get(0).getAttributeName()) && DynamoDBFilterOperator.EQ.equals((Object)(hashKeyFilter = filterMap.get(hashKeyName)).getOperator())) {
            dynamoDBFilters.add(hashKeyFilter);
            hashKeyFilterExists = true;
        }
        if (hashKeyFilterExists && schema.size() > 1 && filterMap.containsKey(rangeKeyName = schema.get(1).getAttributeName()) && this.eligibleOperatorsForRange.contains((rangeKeyFilter = filterMap.get(rangeKeyName)).getOperator())) {
            dynamoDBFilters.add(rangeKeyFilter);
        }
        return dynamoDBFilters;
    }
}

