/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.filter;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import java.util.ArrayList;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilterOperator;
import org.apache.hadoop.hive.dynamodb.filter.AbstractDynamoDBFilter;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;

public class DynamoDBNAryFilter
extends AbstractDynamoDBFilter {
    private final String[] columnValues;

    public DynamoDBNAryFilter(String columnName, DynamoDBFilterOperator operator, String columnType, String ... values) {
        super(columnName, operator, columnType);
        this.columnValues = values;
    }

    @Override
    public Condition createCondition() {
        Condition condition = new Condition();
        condition.setComparisonOperator(this.operator.getDynamoDBName());
        ArrayList<AttributeValue> attributeValueList = new ArrayList<AttributeValue>();
        for (String value : this.columnValues) {
            attributeValueList.add(HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(this.columnType).getAttributeValue(new String[]{value}));
        }
        condition.setAttributeValueList(attributeValueList);
        return condition;
    }
}

