/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.read;

import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBItemWritable;
import org.apache.hadoop.dynamodb.filter.DynamoDBQueryFilter;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.read.DefaultDynamoDBRecordReader;
import org.apache.hadoop.dynamodb.read.DynamoDBInputFormat;
import org.apache.hadoop.dynamodb.split.DynamoDBSplit;
import org.apache.hadoop.dynamodb.split.DynamoDBSplitGenerator;
import org.apache.hadoop.hive.dynamodb.filter.DynamoDBFilterPushdown;
import org.apache.hadoop.hive.dynamodb.shims.ShimsLoader;
import org.apache.hadoop.hive.dynamodb.split.HiveDynamoDBSplitGenerator;
import org.apache.hadoop.hive.dynamodb.util.HiveDynamoDBUtil;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class HiveDynamoDBInputFormat
extends DynamoDBInputFormat {
    private static final Log log = LogFactory.getLog(HiveDynamoDBInputFormat.class);

    static IndexPredicateAnalyzer newIndexPredicateAnalyzer(String keyColumnName) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual");
        analyzer.clearAllowedColumnNames();
        analyzer.allowColumnName(keyColumnName);
        return analyzer;
    }

    public RecordReader<Text, DynamoDBItemWritable> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        reporter.progress();
        Map<String, String> columnMapping = HiveDynamoDBUtil.fromJsonString(conf.get("dynamodb.column.mapping"));
        Map<String, String> hiveTypeMapping = HiveDynamoDBUtil.extractHiveTypeMapping(conf);
        DynamoDBQueryFilter queryFilter = this.getQueryFilter(conf, columnMapping, hiveTypeMapping);
        DynamoDBSplit bbSplit = (DynamoDBSplit)split;
        bbSplit.setDynamoDBFilterPushdown(queryFilter);
        Collection<String> attributes = columnMapping == null ? null : columnMapping.values();
        DynamoDBRecordReaderContext context = this.buildHiveDynamoDBRecordReaderContext((InputSplit)bbSplit, conf, reporter, attributes);
        return new DefaultDynamoDBRecordReader(context);
    }

    protected int getNumSegments(int tableNormalizedReadThroughput, int tableNormalizedWriteThroughput, long currentTableSizeBytes, JobConf conf) throws IOException {
        if (this.isQuery(conf)) {
            log.info((Object)"Defaulting to 1 segment because there are key conditions");
            return 1;
        }
        return super.getNumSegments(tableNormalizedReadThroughput, tableNormalizedWriteThroughput, currentTableSizeBytes, conf);
    }

    protected int getNumMappers(int maxClusterMapTasks, int configuredReadThroughput, JobConf conf) throws IOException {
        if (this.isQuery(conf)) {
            log.info((Object)"Defaulting to 1 mapper because there are key conditions");
            return 1;
        }
        return super.getNumMappers(maxClusterMapTasks, configuredReadThroughput, conf);
    }

    protected DynamoDBSplitGenerator getSplitGenerator() {
        return new HiveDynamoDBSplitGenerator();
    }

    private DynamoDBRecordReaderContext buildHiveDynamoDBRecordReaderContext(InputSplit split, JobConf conf, Reporter reporter, Collection<String> attributes) {
        DynamoDBRecordReaderContext context = super.buildDynamoDBRecordReaderContext(split, conf, reporter);
        context.setAttributes(attributes);
        return context;
    }

    private boolean isQuery(JobConf conf) throws IOException {
        Map<String, String> hiveTypeMapping;
        Map<String, String> hiveDynamoDBMapping = HiveDynamoDBUtil.fromJsonString(conf.get("dynamodb.column.mapping"));
        DynamoDBQueryFilter filter = this.getQueryFilter(conf, hiveDynamoDBMapping, hiveTypeMapping = HiveDynamoDBUtil.extractHiveTypeMapping(conf));
        return filter.getKeyConditions().size() >= 1;
    }

    private DynamoDBQueryFilter getQueryFilter(JobConf conf, Map<String, String> hiveDynamoDBMapping, Map<String, String> hiveTypeMapping) throws IOException {
        if (hiveDynamoDBMapping == null) {
            return new DynamoDBQueryFilter();
        }
        DynamoDBClient client = new DynamoDBClient((Configuration)conf);
        String filterExprSerialized = conf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized == null) {
            return new DynamoDBQueryFilter();
        }
        ExprNodeDesc filterExpr = ShimsLoader.getHiveShims().deserializeExpression(filterExprSerialized);
        DynamoDBFilterPushdown pushdown = new DynamoDBFilterPushdown();
        TableDescription tableDescription = client.describeTable(conf.get("dynamodb.table.name"));
        DynamoDBQueryFilter queryFilter = pushdown.predicateToDynamoDBFilter(tableDescription.getKeySchema(), tableDescription.getLocalSecondaryIndexes(), tableDescription.getGlobalSecondaryIndexes(), hiveDynamoDBMapping, hiveTypeMapping, filterExpr);
        return queryFilter;
    }
}

