/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.dynamodb.filter.DynamoDBQueryFilter;
import org.apache.hadoop.dynamodb.split.DynamoDBSplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;

public class HiveDynamoDBSegmentsSplit
extends FileSplit
implements DynamoDBSplit {
    private long approxItemCount;
    private int splitId;
    private List<Integer> segments;
    private int totalSegments;
    private DynamoDBQueryFilter filterPushdown;

    public HiveDynamoDBSegmentsSplit() {
        super(null, 0L, 0L, (String[])null);
        this.segments = new ArrayList<Integer>();
    }

    public HiveDynamoDBSegmentsSplit(Path path, long approxItemCount, int splitId, List<Integer> segments, int totalSegments, DynamoDBQueryFilter filterPushdown) {
        super(path, 0L, 0L, (String[])null);
        this.approxItemCount = approxItemCount;
        this.segments = segments;
        this.splitId = splitId;
        this.totalSegments = totalSegments;
        this.filterPushdown = filterPushdown;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.approxItemCount = in.readLong();
        this.splitId = in.readInt();
        int numSegments = in.readInt();
        this.segments = new ArrayList<Integer>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            this.segments.add(in.readInt());
        }
        this.totalSegments = in.readInt();
        this.filterPushdown = new DynamoDBQueryFilter();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.approxItemCount);
        out.writeInt(this.splitId);
        out.writeInt(this.segments.size());
        for (Integer segment : this.segments) {
            out.writeInt(segment);
        }
        out.writeInt(this.totalSegments);
    }

    public long getLength() {
        return 0L;
    }

    public String[] getLocations() throws IOException {
        return new String[0];
    }

    public long getApproxItemCount() {
        return this.approxItemCount;
    }

    public int getSplitId() {
        return this.splitId;
    }

    public List<Integer> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public int getTotalSegments() {
        return this.totalSegments;
    }

    public DynamoDBQueryFilter getFilterPushdown() {
        return this.filterPushdown;
    }

    public void setDynamoDBFilterPushdown(DynamoDBQueryFilter filterPushdown) {
        this.filterPushdown = filterPushdown;
    }
}

