/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.type;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.dynamodb.type.DynamoDBBinarySetType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.util.DynamoDBDataParser;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveDynamoDBBinarySetType
extends DynamoDBBinarySetType
implements HiveDynamoDBType {
    @Override
    public AttributeValue getDynamoDBData(Object data, ObjectInspector objectInspector, boolean nullSerialization) {
        List<ByteBuffer> values = DynamoDBDataParser.getByteBuffers(data, objectInspector, this.getDynamoDBType());
        return values == null || values.isEmpty() ? DynamoDBDataParser.getNullAttribute(nullSerialization) : new AttributeValue().withBS(values);
    }

    @Override
    public TypeInfo getSupportedHiveType() {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    }

    @Override
    public boolean supportsHiveType(TypeInfo typeInfo) {
        return typeInfo.equals((Object)this.getSupportedHiveType());
    }

    @Override
    public Object getHiveData(AttributeValue data, ObjectInspector objectInspector) {
        List byteBuffers = data.getBS();
        if (byteBuffers == null || byteBuffers.isEmpty()) {
            return null;
        }
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(byteBuffers.size());
        for (ByteBuffer byteBuffer : byteBuffers) {
            byteArrays.add(Arrays.copyOf(byteBuffer.array(), byteBuffer.array().length));
        }
        return byteArrays;
    }
}

