/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.type;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.key.DynamoDBKey;
import org.apache.hadoop.dynamodb.type.DynamoDBItemType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveDynamoDBItemType
implements DynamoDBItemType,
HiveDynamoDBType {
    private static final Type TYPE = new TypeToken<AttributeValue>(){}.getType();

    @Override
    public Object getHiveData(AttributeValue data, ObjectInspector objectInspector) {
        throw new UnsupportedOperationException("DynamoDBItemType does not support this operation.");
    }

    @Override
    public AttributeValue getDynamoDBData(Object data, ObjectInspector objectInspector, boolean nullSerialization) {
        throw new UnsupportedOperationException("DynamoDBItemType does not support this operation.");
    }

    @Override
    public TypeInfo getSupportedHiveType() {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    @Override
    public boolean supportsHiveType(TypeInfo typeInfo) {
        return typeInfo.equals((Object)this.getSupportedHiveType());
    }

    public AttributeValue getAttributeValue(String ... values) {
        throw new UnsupportedOperationException("DynamoDBItemType does not support this operation.");
    }

    public String getDynamoDBType() {
        return "ITEM";
    }

    public DynamoDBKey getKey(String key) {
        throw new UnsupportedOperationException("DynamoDBItemType does not support this operation.");
    }

    public Map<String, String> buildHiveData(Map<String, AttributeValue> dynamoDBItem) {
        if (dynamoDBItem == null || dynamoDBItem.isEmpty()) {
            throw new RuntimeException("DynamoDB item cannot be null or empty.");
        }
        HashMap<String, String> hiveData = new HashMap<String, String>(dynamoDBItem.size());
        for (Map.Entry<String, AttributeValue> attributeNameValue : dynamoDBItem.entrySet()) {
            hiveData.put(attributeNameValue.getKey(), HiveDynamoDBItemType.serializeAttributeValue(attributeNameValue.getValue()));
        }
        return hiveData;
    }

    public Map<String, AttributeValue> parseDynamoDBData(Object data, ObjectInspector fieldObjectInspector) throws SerDeException {
        if (!HiveDynamoDBTypeFactory.isHiveDynamoDBItemMapType(fieldObjectInspector)) {
            throw new SerDeException(this.getClass().toString() + " Expecting a MapObjectInspector of type map<string,string> for a column which maps DynamoDB item. But we got: " + fieldObjectInspector.getTypeName());
        }
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        MapObjectInspector mapOI = (MapObjectInspector)fieldObjectInspector;
        StringObjectInspector mapKeyObjectInspector = (StringObjectInspector)mapOI.getMapKeyObjectInspector();
        StringObjectInspector mapValueObjectInspector = (StringObjectInspector)mapOI.getMapValueObjectInspector();
        Map map = mapOI.getMap(data);
        if (map == null || map.isEmpty()) {
            throw new SerDeException("Hive data cannot be null.");
        }
        for (Map.Entry entry : map.entrySet()) {
            String dynamoDBAttributeName = mapKeyObjectInspector.getPrimitiveJavaObject(entry.getKey());
            String dynamoDBAttributeValue = mapValueObjectInspector.getPrimitiveJavaObject(entry.getValue());
            AttributeValue deserializedAttributeValue = HiveDynamoDBItemType.deserializeAttributeValue(dynamoDBAttributeValue);
            item.put(dynamoDBAttributeName, deserializedAttributeValue);
        }
        return item;
    }

    private static String serializeAttributeValue(AttributeValue value) {
        Gson gson = DynamoDBUtil.getGson();
        return gson.toJson((Object)value, TYPE);
    }

    public static AttributeValue deserializeAttributeValue(String value) {
        Gson gson = DynamoDBUtil.getGson();
        Object fromJson = gson.fromJson(value, TYPE);
        return (AttributeValue)fromJson;
    }
}

