/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.type;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.List;
import org.apache.hadoop.dynamodb.type.DynamoDBListType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.dynamodb.util.DynamoDBDataParser;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveDynamoDBListType
extends DynamoDBListType
implements HiveDynamoDBType {
    @Override
    public AttributeValue getDynamoDBData(Object data, ObjectInspector objectInspector, boolean nullSerialization) {
        List<AttributeValue> values = DynamoDBDataParser.getListAttribute(data, objectInspector, nullSerialization);
        return values == null ? DynamoDBDataParser.getNullAttribute(nullSerialization) : new AttributeValue().withL(values);
    }

    @Override
    public TypeInfo getSupportedHiveType() {
        throw new UnsupportedOperationException(this.getClass().toString() + " does not support this operation.");
    }

    @Override
    public boolean supportsHiveType(TypeInfo typeInfo) {
        if (typeInfo.getCategory() != ObjectInspector.Category.LIST) {
            return false;
        }
        TypeInfo elementTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
        try {
            HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(elementTypeInfo);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public Object getHiveData(AttributeValue data, ObjectInspector objectInspector) {
        return data.getL() == null ? null : DynamoDBDataParser.getListObject(data.getL(), objectInspector);
    }
}

