/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.type;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.List;
import org.apache.hadoop.dynamodb.type.DynamoDBNumberSetType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.util.DynamoDBDataParser;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveDynamoDBNumberSetType
extends DynamoDBNumberSetType
implements HiveDynamoDBType {
    @Override
    public AttributeValue getDynamoDBData(Object data, ObjectInspector objectInspector, boolean nullSerialization) {
        List<String> values = DynamoDBDataParser.getSetAttribute(data, objectInspector, this.getDynamoDBType());
        return values == null || values.isEmpty() ? DynamoDBDataParser.getNullAttribute(nullSerialization) : new AttributeValue().withNS(values);
    }

    @Override
    public TypeInfo getSupportedHiveType() {
        throw new UnsupportedOperationException(this.getClass().toString() + " does not support this operation.");
    }

    @Override
    public boolean supportsHiveType(TypeInfo typeInfo) {
        return typeInfo.equals((Object)TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.doubleTypeInfo)) || typeInfo.equals((Object)TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo));
    }

    @Override
    public Object getHiveData(AttributeValue data, ObjectInspector objectInspector) {
        return data.getNS() == null ? null : DynamoDBDataParser.getNumberObjectList(data.getNS(), objectInspector);
    }
}

