/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.type;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.dynamodb.type.DynamoDBTypeFactory;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBBinarySetType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBBinaryType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBBooleanType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBItemType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBListType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBMapType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBNullType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBNumberSetType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBNumberType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBStringSetType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBStringType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveDynamoDBTypeFactory
extends DynamoDBTypeFactory {
    private static final HiveDynamoDBType DYNAMODB_ITEM_TYPE = new HiveDynamoDBItemType();
    private static final Set<HiveDynamoDBType> DEFAULT_HIVE_DYNAMODB_TYPES = Sets.newHashSet((Object[])new HiveDynamoDBType[]{new HiveDynamoDBStringType(), new HiveDynamoDBBinaryType(), new HiveDynamoDBNumberType(), new HiveDynamoDBBooleanType(), new HiveDynamoDBListType(), new HiveDynamoDBItemType(), new HiveDynamoDBMapType()});
    private static final Set<HiveDynamoDBType> ALTERNATE_HIVE_DYNAMODB_TYPES = Sets.newHashSet((Object[])new HiveDynamoDBType[]{new HiveDynamoDBStringSetType(), new HiveDynamoDBBinarySetType(), new HiveDynamoDBNumberSetType(), new HiveDynamoDBNullType()});
    private static final Map<TypeInfo, HiveDynamoDBType> SIMPLE_HIVE_DYNAMODB_TYPES_MAP = Maps.newHashMap();
    private static final Set<HiveDynamoDBType> COMPLEX_HIVE_DYNAMODB_TYPES_SET = Sets.newHashSet();
    private static final Map<String, HiveDynamoDBType> DYNAMODB_TYPE_MAP = Maps.newHashMap();

    public static HiveDynamoDBType getTypeObjectFromHiveType(String hiveType) {
        return HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType));
    }

    public static HiveDynamoDBType getTypeObjectFromHiveType(ObjectInspector objectInspector) {
        return HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)objectInspector));
    }

    public static HiveDynamoDBType getTypeObjectFromHiveType(TypeInfo typeInfo) {
        if (SIMPLE_HIVE_DYNAMODB_TYPES_MAP.containsKey(typeInfo)) {
            return SIMPLE_HIVE_DYNAMODB_TYPES_MAP.get(typeInfo);
        }
        for (HiveDynamoDBType type : COMPLEX_HIVE_DYNAMODB_TYPES_SET) {
            if (!type.supportsHiveType(typeInfo)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported Hive type: " + typeInfo.getTypeName());
    }

    public static HiveDynamoDBType getTypeObjectFromDynamoDBType(String dynamoDBType) {
        if (DYNAMODB_TYPE_MAP.containsKey(dynamoDBType)) {
            return DYNAMODB_TYPE_MAP.get(dynamoDBType);
        }
        throw new IllegalArgumentException("Unsupported DynamoDB type: " + dynamoDBType);
    }

    public static boolean isHiveDynamoDBItemMapType(String hiveType) {
        return DYNAMODB_ITEM_TYPE.supportsHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType));
    }

    public static boolean isHiveDynamoDBItemMapType(ObjectInspector objectInspector) {
        return DYNAMODB_ITEM_TYPE.supportsHiveType(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)objectInspector));
    }

    public static boolean isHiveDynamoDBItemMapType(HiveDynamoDBType ddType) {
        return ddType.getDynamoDBType().equals("ITEM");
    }

    static {
        for (HiveDynamoDBType type : DEFAULT_HIVE_DYNAMODB_TYPES) {
            try {
                SIMPLE_HIVE_DYNAMODB_TYPES_MAP.put(type.getSupportedHiveType(), type);
            }
            catch (UnsupportedOperationException e) {
                COMPLEX_HIVE_DYNAMODB_TYPES_SET.add(type);
            }
            DYNAMODB_TYPE_MAP.put(type.getDynamoDBType(), type);
        }
        for (HiveDynamoDBType type : ALTERNATE_HIVE_DYNAMODB_TYPES) {
            DYNAMODB_TYPE_MAP.put(type.getDynamoDBType(), type);
        }
    }
}

