/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.util;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class DynamoDBDataParser {
    private static final Log log = LogFactory.getLog(DynamoDBDataParser.class);

    public static String getNumber(Object data, ObjectInspector objectInspector) {
        if (objectInspector.getTypeName().equals("double")) {
            return Double.toString(((DoubleObjectInspector)objectInspector).get(data));
        }
        if (objectInspector.getTypeName().equals("bigint")) {
            return Long.toString(((LongObjectInspector)objectInspector).get(data));
        }
        throw new IllegalArgumentException("Unknown object inspector type: " + objectInspector.getCategory() + " Type name: " + objectInspector.getTypeName());
    }

    public static Boolean getBoolean(Object data, ObjectInspector objectInspector) {
        return ((BooleanObjectInspector)objectInspector).get(data);
    }

    public static String getString(Object data, ObjectInspector objectInspector) {
        return ((StringObjectInspector)objectInspector).getPrimitiveJavaObject(data);
    }

    public static ByteBuffer getByteBuffer(Object data, ObjectInspector objectInspector) {
        BytesWritable bw = ((BinaryObjectInspector)objectInspector).getPrimitiveWritableObject(data);
        byte[] result = new byte[bw.getLength()];
        System.arraycopy(bw.getBytes(), 0, result, 0, bw.getLength());
        return ByteBuffer.wrap(result);
    }

    public static Map<String, AttributeValue> getMapAttribute(Object data, ObjectInspector objectInspector, boolean nullSerialization) {
        HashMap<String, AttributeValue> itemMap = new HashMap<String, AttributeValue>();
        switch (objectInspector.getCategory()) {
            case MAP: {
                MapObjectInspector mapOI = (MapObjectInspector)objectInspector;
                Map dataMap = mapOI.getMap(data);
                if (dataMap == null) {
                    return null;
                }
                StringObjectInspector mapKeyOI = (StringObjectInspector)mapOI.getMapKeyObjectInspector();
                ObjectInspector mapValueOI = mapOI.getMapValueObjectInspector();
                HiveDynamoDBType valueType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(mapValueOI);
                for (Map.Entry entry : dataMap.entrySet()) {
                    AttributeValue attributeValue;
                    String attributeName = mapKeyOI.getPrimitiveJavaObject(entry.getKey());
                    Object valueData = entry.getValue();
                    AttributeValue attributeValue2 = attributeValue = valueData == null ? DynamoDBDataParser.getNullAttribute(nullSerialization) : valueType.getDynamoDBData(valueData, mapValueOI, nullSerialization);
                    if (attributeValue == null) {
                        throw new NullPointerException("Null field found in map: " + dataMap);
                    }
                    itemMap.put(attributeName, attributeValue);
                }
                break;
            }
            case STRUCT: {
                StructObjectInspector structOI = (StructObjectInspector)objectInspector;
                List fields = structOI.getAllStructFieldRefs();
                for (StructField field : fields) {
                    AttributeValue attributeValue;
                    Object fieldData = structOI.getStructFieldData(data, field);
                    ObjectInspector fieldOI = field.getFieldObjectInspector();
                    HiveDynamoDBType fieldType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(fieldOI);
                    String attributeName = field.getFieldName();
                    AttributeValue attributeValue3 = attributeValue = fieldData == null ? DynamoDBDataParser.getNullAttribute(nullSerialization) : fieldType.getDynamoDBData(fieldData, fieldOI, nullSerialization);
                    if (attributeValue == null) {
                        throw new NullPointerException("Null field found in struct: " + structOI.getStructFieldsDataAsList(data));
                    }
                    itemMap.put(attributeName, attributeValue);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown object inspector type: " + objectInspector.getCategory() + " Type name: " + objectInspector.getTypeName());
            }
        }
        return itemMap;
    }

    public static List<AttributeValue> getListAttribute(Object data, ObjectInspector objectInspector, boolean nullSerialization) {
        ListObjectInspector listObjectInspector = (ListObjectInspector)objectInspector;
        List dataList = listObjectInspector.getList(data);
        if (dataList == null) {
            return null;
        }
        ObjectInspector itemObjectInspector = listObjectInspector.getListElementObjectInspector();
        HiveDynamoDBType itemType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(itemObjectInspector);
        ArrayList<AttributeValue> itemList = new ArrayList<AttributeValue>();
        for (Object dataItem : dataList) {
            AttributeValue item;
            AttributeValue attributeValue = item = dataItem == null ? DynamoDBDataParser.getNullAttribute(nullSerialization) : itemType.getDynamoDBData(dataItem, itemObjectInspector, nullSerialization);
            if (item == null) {
                throw new NullPointerException("Null element found in list: " + dataList);
            }
            itemList.add(item);
        }
        return itemList;
    }

    public static List<String> getSetAttribute(Object data, ObjectInspector objectInspector, String ddType) {
        ListObjectInspector listObjectInspector = (ListObjectInspector)objectInspector;
        List dataList = listObjectInspector.getList(data);
        if (dataList == null) {
            return null;
        }
        ObjectInspector itemObjectInspector = listObjectInspector.getListElementObjectInspector();
        ArrayList<String> itemList = new ArrayList<String>();
        for (Object dataItem : dataList) {
            if (dataItem == null) {
                throw new NullPointerException("Null element found in list: " + dataList);
            }
            if (ddType.equals("SS")) {
                itemList.add(DynamoDBDataParser.getString(dataItem, itemObjectInspector));
                continue;
            }
            if (ddType.equals("NS")) {
                itemList.add(DynamoDBDataParser.getNumber(dataItem, itemObjectInspector));
                continue;
            }
            throw new IllegalArgumentException("Expecting NumberSet or StringSet type: " + ddType);
        }
        return itemList;
    }

    public static List<ByteBuffer> getByteBuffers(Object data, ObjectInspector objectInspector, String ddType) {
        ListObjectInspector listObjectInspector = (ListObjectInspector)objectInspector;
        List dataList = listObjectInspector.getList(data);
        if (dataList == null) {
            return null;
        }
        ObjectInspector itemObjectInspector = listObjectInspector.getListElementObjectInspector();
        ArrayList<ByteBuffer> itemList = new ArrayList<ByteBuffer>();
        for (Object dataItem : dataList) {
            if (dataItem == null) {
                throw new NullPointerException("Null element found in list: " + dataList);
            }
            if (ddType.equals("BS")) {
                itemList.add(DynamoDBDataParser.getByteBuffer(dataItem, itemObjectInspector));
                continue;
            }
            throw new IllegalArgumentException("Expecting BinarySet type: " + ddType);
        }
        return itemList;
    }

    public static AttributeValue getNullAttribute(boolean nullSerialization) {
        return nullSerialization ? HiveDynamoDBTypeFactory.getTypeObjectFromDynamoDBType("NULL").getAttributeValue(new String[0]) : null;
    }

    public static Object getNumberObjectList(List<String> data, ObjectInspector objectInspector) {
        ListObjectInspector listOI = (ListObjectInspector)objectInspector;
        ObjectInspector itemOI = listOI.getListElementObjectInspector();
        ArrayList<Object> numberValues = new ArrayList<Object>();
        for (String item : data) {
            if (item == null) {
                throw new NullPointerException("Null element found in list: " + data);
            }
            numberValues.add(DynamoDBDataParser.getNumberObject(item, itemOI));
        }
        return numberValues;
    }

    public static Object getNumberObject(String data, ObjectInspector objectInspector) {
        String hiveType = objectInspector.getTypeName();
        if (hiveType.equals("bigint")) {
            return Long.parseLong(data);
        }
        if (hiveType.equals("double")) {
            return Double.parseDouble(data);
        }
        throw new IllegalArgumentException("Unsupported Hive type: " + hiveType);
    }

    public static Object getListObject(List<AttributeValue> data, ObjectInspector objectInspector) {
        ListObjectInspector listOI = (ListObjectInspector)objectInspector;
        ObjectInspector elementOI = listOI.getListElementObjectInspector();
        HiveDynamoDBType elementType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(elementOI);
        ArrayList<Object> values = new ArrayList<Object>();
        for (AttributeValue av : data) {
            values.add(elementType.getHiveData(av, elementOI));
        }
        return values;
    }

    public static Object getMapObject(Map<String, AttributeValue> data, ObjectInspector objectInspector) {
        MapObjectInspector mapOI = (MapObjectInspector)objectInspector;
        ObjectInspector mapValueOI = mapOI.getMapValueObjectInspector();
        HiveDynamoDBType valueType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(mapValueOI);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeValue> entry : data.entrySet()) {
            values.put(entry.getKey(), valueType.getHiveData(entry.getValue(), mapValueOI));
        }
        return values;
    }

    public static Object getStructObject(Map<String, AttributeValue> data, ObjectInspector objectInspector) {
        StructObjectInspector structOI = (StructObjectInspector)objectInspector;
        List structFields = structOI.getAllStructFieldRefs();
        ArrayList<Object> values = new ArrayList<Object>();
        for (StructField field : structFields) {
            values.add(DynamoDBDataParser.getStructFieldObject(data, field));
        }
        return values;
    }

    private static Object getStructFieldObject(Map<String, AttributeValue> data, StructField field) {
        String fieldName = field.getFieldName();
        ObjectInspector fieldOI = field.getFieldObjectInspector();
        HiveDynamoDBType ddType = HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(fieldOI);
        for (Map.Entry<String, AttributeValue> entry : data.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(fieldName)) continue;
            return ddType.getHiveData(entry.getValue(), fieldOI);
        }
        throw new NullPointerException("Field name not found in map: " + fieldName);
    }
}

