/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBType;
import org.apache.hadoop.hive.dynamodb.type.HiveDynamoDBTypeFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.JobConf;

public final class HiveDynamoDBUtil {
    private static final Log LOG = LogFactory.getLog(HiveDynamoDBUtil.class);
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    private HiveDynamoDBUtil() {
    }

    public static String getDynamoDBTableName(String tablePropertyDefinedTableName, String hiveTableName) {
        if (tablePropertyDefinedTableName == null || tablePropertyDefinedTableName.isEmpty()) {
            return hiveTableName;
        }
        return tablePropertyDefinedTableName;
    }

    public static Map<String, String> getHiveToDynamoDBColumnMapping(Properties props) {
        return HiveDynamoDBUtil.getHiveToDynamoDBMapping(props.getProperty("dynamodb.column.mapping"));
    }

    public static Map<String, HiveDynamoDBType> getHiveToDynamoDBTypeMapping(List<String> columnNames, List<TypeInfo> columnTypes, Properties props) {
        HashMap typeMappings = Maps.newHashMap();
        Map<String, String> altTypeMappings = HiveDynamoDBUtil.getHiveToDynamoDBMapping(props.getProperty("dynamodb.type.mapping"));
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            HiveDynamoDBType ddType = altTypeMappings.containsKey(columnName) ? HiveDynamoDBTypeFactory.getTypeObjectFromDynamoDBType(altTypeMappings.get(columnName)) : HiveDynamoDBTypeFactory.getTypeObjectFromHiveType(columnTypes.get(i));
            typeMappings.put(columnName, ddType);
        }
        return typeMappings;
    }

    public static boolean getHiveToDynamoDBNullSerialization(Properties tbl) {
        return Boolean.parseBoolean(tbl.getProperty("dynamodb.null.serialization"));
    }

    public static String toJsonString(Map<String, String> dynamoDBTypeMapping) {
        return gson.toJson(dynamoDBTypeMapping, MAP_TYPE);
    }

    public static Map<String, String> fromJsonString(String jsonString) {
        return (Map)gson.fromJson(jsonString, MAP_TYPE);
    }

    public static Map<String, String> getHiveToDynamoDBMapping(String mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return Maps.newHashMap();
        }
        String[] mapArray = mapping.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : mapArray) {
            String[] keyValue = entry.split(":", 2);
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Invalid entry in mapping " + entry);
            }
            map.put(keyValue[0].toLowerCase(), keyValue[1]);
        }
        return map;
    }

    public static Map<String, String> extractHiveTypeMapping(JobConf jobConf) {
        HashMap<String, String> map = new HashMap<String, String>();
        String columnsString = jobConf.get("columns");
        if (columnsString == null || columnsString.isEmpty()) {
            LOG.warn((Object)"List of columns was not provided in job configuration");
            return map;
        }
        String[] columns = columnsString.split(",");
        String[] types = HiveDynamoDBUtil.splitStructs(jobConf.get("columns.types"), ',');
        if (types == null) {
            LOG.warn((Object)"Invalid input for LIST_COLUMN_TYPES");
            return map;
        }
        if (columns.length != types.length) {
            LOG.warn((Object)("Expected " + columns.length + " types but found " + types.length));
            return map;
        }
        for (int i = 0; i < columns.length; ++i) {
            map.put(columns[i], types[i]);
        }
        LOG.debug((Object)("Hive columns to types mapping: " + map));
        return map;
    }

    private static String[] splitStructs(String str, char separator) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        int start = 0;
        int match = 0;
        while (index < len) {
            if (str.charAt(index) == '<') {
                ++match;
            } else if (str.charAt(index) == '>') {
                --match;
            } else if (str.charAt(index) == separator && match == 0) {
                list.add(str.substring(start, index).trim());
                start = ++index;
                continue;
            }
            ++index;
        }
        if (match != 0) {
            return null;
        }
        list.add(str.substring(start, index).trim());
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }
}

