/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.dynamodb.shims;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hive.dynamodb.shims.DynamoDbHive1Dot2Shims;
import org.apache.hadoop.hive.dynamodb.shims.DynamoDbHive1Shims;
import org.apache.hadoop.hive.dynamodb.shims.DynamoDbHive2Shims;
import org.apache.hadoop.hive.dynamodb.shims.DynamoDbHiveShims;
import org.apache.hive.common.util.HiveVersionInfo;

public final class ShimsLoader {
    private static DynamoDbHiveShims hiveShims;

    public static synchronized DynamoDbHiveShims getHiveShims() {
        if (hiveShims == null) {
            hiveShims = ShimsLoader.loadHiveShims();
        }
        return hiveShims;
    }

    private static DynamoDbHiveShims loadHiveShims() {
        String hiveVersion = HiveVersionInfo.getShortVersion();
        if (DynamoDbHive1Shims.supportsVersion((String)hiveVersion)) {
            try {
                return (DynamoDbHiveShims)DynamoDbHive1Shims.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("unable to get instance of Hive 1.x shim class");
            }
        }
        if (DynamoDbHive1Dot2Shims.supportsVersion((String)hiveVersion)) {
            try {
                return (DynamoDbHiveShims)DynamoDbHive1Dot2Shims.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("unable to get instance of Hive 1.2.x shim class");
            }
        }
        if (DynamoDbHive2Shims.supportsVersion((String)hiveVersion)) {
            try {
                return (DynamoDbHiveShims)DynamoDbHive2Shims.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("unable to get instance of Hive 2.x shim class");
            }
        }
        throw new RuntimeException("Shim class for Hive version " + hiveVersion + " does not exist");
    }

    @VisibleForTesting
    static synchronized void clearShimClass() {
        hiveShims = null;
    }
}

