/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.system;

import com.amazon.ion.IonCatalog;
import com.amazon.ion.IonSystem;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.impl._Private_IonBinaryWriterBuilder;
import com.amazon.ion.impl._Private_Utils;
import com.amazon.ion.impl.lite._Private_LiteDomTrampoline;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ion.system.IonTextWriterBuilder;
import com.amazon.ion.system.SimpleCatalog;
import java.util.Objects;
import java.util.Optional;

public class IonSystemBuilder {
    private static final IonSystemBuilder STANDARD = new IonSystemBuilder();
    IonCatalog myCatalog;
    boolean myStreamCopyOptimized = false;
    IonTextWriterBuilder textWriterBuilder = IonTextWriterBuilder.standard();
    IonBinaryWriterBuilder binaryWriterBuilder = IonBinaryWriterBuilder.standard();
    IonReaderBuilder readerBuilder = IonReaderBuilder.standard();

    public static IonSystemBuilder standard() {
        return STANDARD;
    }

    private IonSystemBuilder() {
    }

    private IonSystemBuilder(IonSystemBuilder that) {
        this.myCatalog = that.myCatalog;
        this.myStreamCopyOptimized = that.myStreamCopyOptimized;
        this.textWriterBuilder = that.textWriterBuilder;
        this.binaryWriterBuilder = that.binaryWriterBuilder;
        this.readerBuilder = that.readerBuilder;
    }

    public final IonSystemBuilder copy() {
        return new Mutable(this);
    }

    public IonSystemBuilder immutable() {
        return this;
    }

    public IonSystemBuilder mutable() {
        return this.copy();
    }

    void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public final IonCatalog getCatalog() {
        return this.myCatalog;
    }

    public final void setCatalog(IonCatalog catalog) {
        this.mutationCheck();
        this.myCatalog = catalog;
    }

    public final IonSystemBuilder withCatalog(IonCatalog catalog) {
        IonSystemBuilder b = this.mutable();
        b.setCatalog(catalog);
        return b;
    }

    public final boolean isStreamCopyOptimized() {
        return this.myStreamCopyOptimized;
    }

    public final void setStreamCopyOptimized(boolean optimized) {
        this.mutationCheck();
        this.myStreamCopyOptimized = optimized;
    }

    public final IonSystemBuilder withStreamCopyOptimized(boolean optimized) {
        IonSystemBuilder b = this.mutable();
        b.setStreamCopyOptimized(optimized);
        return b;
    }

    public final IonTextWriterBuilder getIonTextWriterBuilder() {
        return this.textWriterBuilder;
    }

    public final void setIonTextWriterBuilder(IonTextWriterBuilder builder) {
        this.mutationCheck();
        this.textWriterBuilder = Objects.requireNonNull(builder);
    }

    public final IonSystemBuilder withIonTextWriterBuilder(IonTextWriterBuilder builder) {
        IonSystemBuilder b = this.mutable();
        b.setIonTextWriterBuilder(builder);
        return b;
    }

    public final IonBinaryWriterBuilder getIonBinaryWriterBuilder() {
        return this.binaryWriterBuilder;
    }

    public final void setIonBinaryWriterBuilder(IonBinaryWriterBuilder builder) {
        this.mutationCheck();
        this.binaryWriterBuilder = Objects.requireNonNull(builder);
    }

    public final IonSystemBuilder withIonBinaryWriterBuilder(IonBinaryWriterBuilder builder) {
        IonSystemBuilder b = this.mutable();
        b.setIonBinaryWriterBuilder(builder);
        return b;
    }

    public final IonReaderBuilder getReaderBuilder() {
        return this.readerBuilder;
    }

    public final void setReaderBuilder(IonReaderBuilder builder) {
        this.mutationCheck();
        this.readerBuilder = Objects.requireNonNull(builder);
    }

    public final IonSystemBuilder withReaderBuilder(IonReaderBuilder builder) {
        IonSystemBuilder b = this.mutable();
        b.setReaderBuilder(builder);
        return b;
    }

    public final IonSystem build() {
        IonCatalog catalog = Optional.ofNullable(this.myCatalog).orElseGet(SimpleCatalog::new);
        IonTextWriterBuilder twb = this.textWriterBuilder.copy().withCatalog(catalog);
        IonBinaryWriterBuilder bwb = this.binaryWriterBuilder.copy().withCatalog(catalog);
        IonReaderBuilder rb = this.readerBuilder.copy().withCatalog(catalog);
        bwb.setStreamCopyOptimized(this.myStreamCopyOptimized);
        SymbolTable systemSymtab = _Private_Utils.systemSymtab(1);
        bwb.setInitialSymbolTable(systemSymtab);
        return _Private_LiteDomTrampoline.newLiteSystem(twb, (_Private_IonBinaryWriterBuilder)bwb, rb);
    }

    private static final class Mutable
    extends IonSystemBuilder {
        private Mutable(IonSystemBuilder that) {
            super(that);
        }

        @Override
        public IonSystemBuilder immutable() {
            return new IonSystemBuilder(this);
        }

        @Override
        public IonSystemBuilder mutable() {
            return this;
        }

        @Override
        void mutationCheck() {
        }
    }
}

