/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc;

import com.amazon.opendistroforelasticsearch.jdbc.ConnectionImpl;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionConfig;
import com.amazon.opendistroforelasticsearch.jdbc.internal.Version;
import com.amazon.opendistroforelasticsearch.jdbc.internal.util.UrlParser;
import com.amazon.opendistroforelasticsearch.jdbc.logging.Logger;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LoggerFactory;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LoggingSource;
import com.amazon.opendistroforelasticsearch.jdbc.logging.NoOpLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;

public class Driver
implements java.sql.Driver,
LoggingSource {
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ConnectionConfig connectionConfig = ConnectionConfig.builder().setUrl(url).setProperties(info).build();
        Logger log = Driver.initLog(connectionConfig);
        log.debug(() -> this.logMessage("connect (%s, %s)", url, info == null ? "null" : info.toString()));
        log.debug(() -> this.logMessage("Opening connection using config: %s", connectionConfig));
        return new ConnectionImpl(connectionConfig, log);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return UrlParser.isAcceptable(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return Version.Current.getMajor();
    }

    @Override
    public int getMinorVersion() {
        return Version.Current.getMinor();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static Logger initLog(ConnectionConfig connectionConfig) {
        if (connectionConfig.getLogWriter() != null) {
            return LoggerFactory.getLogger(connectionConfig.getLogWriter(), connectionConfig.getLogLevel());
        }
        if (connectionConfig.getLogOutput() != null) {
            return LoggerFactory.getLogger(connectionConfig.getLogOutput(), connectionConfig.getLogLevel());
        }
        if (DriverManager.getLogWriter() != null) {
            return LoggerFactory.getLogger(DriverManager.getLogWriter(), connectionConfig.getLogLevel());
        }
        return NoOpLogger.INSTANCE;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

