/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc;

import com.amazon.opendistroforelasticsearch.jdbc.ResultSetImpl;
import com.amazon.opendistroforelasticsearch.jdbc.internal.JdbcWrapper;
import com.amazon.opendistroforelasticsearch.jdbc.internal.results.Schema;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetMetaDataImpl
implements ResultSetMetaData,
JdbcWrapper {
    private ResultSetImpl resultSet;
    private Schema schema;

    public ResultSetMetaDataImpl(ResultSetImpl resultSet, Schema schema) {
        this.resultSet = resultSet;
        this.schema = schema;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.schema.getNumberOfColumns();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkAccessible(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkAccessible(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkAccessible(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkAccessible(column);
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getEsType().isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getEsType().getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getTableSchemaName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getColumnMetaData(column - 1).getCatalogName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getElasticsearchType(column - 1).getJdbcType().getVendorTypeNumber();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getElasticsearchType(column - 1).getJdbcType().getName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkAccessible(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkAccessible(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkAccessible(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkAccessible(column);
        return this.schema.getElasticsearchType(column - 1).getJavaClassName();
    }

    private void checkAccessible(int columnIndex) throws SQLException {
        this.checkOpen();
        this.checkColumnIndex(columnIndex);
    }

    private void checkOpen() throws SQLException {
        this.resultSet.checkOpen();
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        this.resultSet.checkColumnIndex(columnIndex);
    }
}

