/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.config;

import com.amazon.opendistroforelasticsearch.jdbc.auth.AuthenticationType;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionProperty;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionPropertyException;
import java.util.Locale;

public class AuthConnectionProperty
extends ConnectionProperty<AuthenticationType> {
    public static final String KEY = "auth";

    public AuthConnectionProperty() {
        super(KEY);
    }

    @Override
    protected AuthenticationType parseValue(Object rawValue) throws ConnectionPropertyException {
        if (rawValue == null) {
            return this.getDefault();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            try {
                return AuthenticationType.valueOf(stringValue.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException iae) {
                throw new ConnectionPropertyException(this.getKey(), String.format("Invalid value specified for the property \"%s\". Unknown authentication type \"%s\".", this.getKey(), stringValue));
            }
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property \"%s\" requires a valid String matching a known authentication type. Invalid value of type: %s specified.", this.getKey(), rawValue.getClass().getName()));
    }

    @Override
    public AuthenticationType getDefault() {
        return AuthenticationType.NONE;
    }
}

