/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.config;

import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionProperty;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionPropertyException;

public class BoolConnectionProperty
extends ConnectionProperty<Boolean> {
    public BoolConnectionProperty(String key) {
        super(key);
    }

    @Override
    protected Boolean parseValue(Object value) throws ConnectionPropertyException {
        if (value == null) {
            return this.getDefault();
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property %s requires a valid boolean. Invalid property value of type %s. ", this.getKey(), value.getClass().getName()));
    }

    @Override
    public Boolean getDefault() {
        return false;
    }
}

