/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.config;

import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionProperty;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionPropertyException;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LogLevel;
import java.util.Locale;

public class LogLevelConnectionProperty
extends ConnectionProperty<LogLevel> {
    public static final String KEY = "logLevel";

    public LogLevelConnectionProperty() {
        super(KEY);
    }

    @Override
    protected LogLevel parseValue(Object rawValue) throws ConnectionPropertyException {
        if (rawValue == null) {
            return this.getDefault();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            try {
                return LogLevel.valueOf(stringValue.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException iae) {
                throw new ConnectionPropertyException(this.getKey(), String.format("Invalid value specified for the property \"%s\". Unknown log level \"%s\".", this.getKey(), stringValue));
            }
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property \"%s\" requires a valid String matching a known log level. Invalid value of type: %s specified.", this.getKey(), rawValue.getClass().getName()));
    }

    @Override
    public LogLevel getDefault() {
        return LogLevel.OFF;
    }
}

