/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.config;

import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionPropertyException;
import com.amazon.opendistroforelasticsearch.jdbc.config.IntConnectionProperty;

public class PortConnectionProperty
extends IntConnectionProperty {
    public static final String KEY = "port";

    public PortConnectionProperty() {
        super(KEY);
    }

    @Override
    protected Integer parseValue(Object value) throws ConnectionPropertyException {
        int intValue = super.parseValue(value);
        if (intValue < 0 || intValue > 65535) {
            throw new ConnectionPropertyException(this.getKey(), String.format("Port number property requires a valid integer (0-65535). Invalid value: %d", intValue));
        }
        return intValue;
    }

    @Override
    public Integer getDefault() {
        return 9200;
    }
}

