/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AwsHostNameUtil {
    private static final Pattern REGION_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)$");
    private static final Pattern KNOWN_HOSTNAME_PATTERN = Pattern.compile("^(?:.+)?(\\.es\\.[a-z0-9]+\\.com)$");

    public static String parseRegion(String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        String region = null;
        int knownSuffixLength = 0;
        Matcher matcher = KNOWN_HOSTNAME_PATTERN.matcher(hostname);
        if (matcher.matches()) {
            knownSuffixLength = matcher.group(1).length();
        }
        if (knownSuffixLength > 0) {
            int index = hostname.length() - knownSuffixLength;
            region = AwsHostNameUtil.parseStandardRegionName(hostname.substring(0, index));
        }
        return region;
    }

    private static String parseStandardRegionName(String fragment) {
        Matcher matcher = REGION_PATTERN.matcher(fragment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

