/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.internal.util;

public class SqlParser {
    public static int countParameterMarkers(String sql) {
        if (sql == null) {
            return 0;
        }
        int count = 0;
        block5: for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    i = SqlParser.locateQuoteEnd(sql, ch, i + 1);
                    continue block5;
                }
                case '?': {
                    ++count;
                    continue block5;
                }
                case '-': 
                case '/': {
                    i = SqlParser.locateCommentEnd(sql, ch, i);
                }
            }
        }
        return count;
    }

    private static int locateCommentEnd(String s, char commentStartChar, int commentStartIndex) {
        int idx;
        if (commentStartIndex + 1 > s.length()) {
            return commentStartIndex;
        }
        if (commentStartChar == '-' && s.charAt(commentStartIndex + 1) == '-') {
            idx = SqlParser.locateLineEnd(s, commentStartIndex + 2);
        } else if (commentStartChar == '/' && s.charAt(commentStartIndex + 1) == '*') {
            idx = s.indexOf("*/", commentStartIndex + 2);
        } else {
            return commentStartIndex;
        }
        if (idx == -1) {
            throw new IllegalArgumentException("SQL text contains an unterminated comment.");
        }
        return idx;
    }

    private static int locateQuoteEnd(String s, char ch, int fromIndex) {
        int idx = s.indexOf(ch, fromIndex);
        if (idx == -1) {
            throw new IllegalArgumentException("SQL text contains an unterminated string. This could possibly be due to mismatched quotes in the statement.");
        }
        return idx;
    }

    private static int locateLineEnd(String s, int fromIndex) {
        char ch;
        int idx;
        for (idx = fromIndex; idx < s.length() && (ch = s.charAt(idx)) != '\r' && ch != '\n'; ++idx) {
        }
        return idx;
    }
}

