/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.StringTokenizer;

public class UrlParser {
    public static final String URL_PREFIX = "jdbc:elasticsearch://";
    private static final int URL_PREFIX_LEN = "jdbc:elasticsearch://".length();
    private static final String SCHEME_DELIM = "://";

    public static boolean isAcceptable(String url) {
        return url != null && url.startsWith(URL_PREFIX);
    }

    public static Properties parseProperties(String inputUrl) throws URISyntaxException {
        if (inputUrl == null || inputUrl.indexOf(URL_PREFIX) != 0) {
            throw new URISyntaxException(inputUrl, String.format("URL does not begin with the mandatory prefix %s.", URL_PREFIX));
        }
        String trimmedUrl = inputUrl.trim();
        int schemeDelimIdx = trimmedUrl.indexOf(SCHEME_DELIM, URL_PREFIX_LEN);
        URI uri = null;
        if (schemeDelimIdx != -1) {
            uri = UrlParser.toURI(UrlParser.extractTargetUrl(trimmedUrl));
        } else if (URL_PREFIX_LEN < trimmedUrl.length()) {
            uri = UrlParser.toURI("http://" + UrlParser.extractTargetUrl(trimmedUrl));
        }
        Properties props = new Properties();
        if (uri != null) {
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            if (host != null) {
                props.setProperty("host", host);
            }
            if (port != -1) {
                props.setProperty("port", Integer.toString(port));
            }
            if (path != null && path.length() > 0) {
                props.setProperty("path", path);
            }
            if ("https".equalsIgnoreCase(scheme)) {
                props.setProperty("useSSL", "true");
            } else if ("http".equalsIgnoreCase(scheme)) {
                props.setProperty("useSSL", "false");
            } else {
                throw new URISyntaxException(inputUrl, "Invalid scheme:" + scheme + ". Only http and https are supported.");
            }
            String query = uri.getRawQuery();
            if (query != null) {
                StringTokenizer tokenizer = new StringTokenizer(query, "&");
                while (tokenizer.hasMoreElements()) {
                    String kvp = tokenizer.nextToken();
                    String[] kv = kvp.split("=");
                    if (kv.length != 2) {
                        throw new URISyntaxException(inputUrl, "QueryString format of URL invalid. Found unexpected format at " + kv[0] + ". Expected key=value pairs");
                    }
                    props.setProperty(kv[0], kv[1]);
                }
            }
        }
        return props;
    }

    private static String extractTargetUrl(String url) {
        return url.substring(URL_PREFIX_LEN);
    }

    private static URI toURI(String str) throws URISyntaxException {
        return new URI(str);
    }
}

