/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.logging;

import com.amazon.opendistroforelasticsearch.jdbc.logging.FilePrintWriterLogger;
import com.amazon.opendistroforelasticsearch.jdbc.logging.Layout;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LogLevel;
import com.amazon.opendistroforelasticsearch.jdbc.logging.Logger;
import com.amazon.opendistroforelasticsearch.jdbc.logging.PrintWriterLogger;
import com.amazon.opendistroforelasticsearch.jdbc.logging.StandardLayout;
import java.io.IOException;
import java.io.PrintWriter;

public class LoggerFactory {
    public static Logger getLogger(String filePath, LogLevel logLevel) {
        return LoggerFactory.getLogger(filePath, logLevel, (Layout)StandardLayout.INSTANCE);
    }

    public static Logger getLogger(String filePath, LogLevel logLevel, Layout layout) {
        try {
            return new FilePrintWriterLogger(filePath, logLevel, layout);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Logger getLogger(PrintWriter printWriter, LogLevel logLevel) {
        return LoggerFactory.getLogger(printWriter, logLevel, (Layout)StandardLayout.INSTANCE);
    }

    public static Logger getLogger(PrintWriter printWriter, LogLevel logLevel, Layout layout) {
        return new PrintWriterLogger(printWriter, logLevel, layout);
    }
}

