/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.protocol.http;

import com.amazon.opendistroforelasticsearch.jdbc.protocol.exceptions.ResponseException;

public class HttpException
extends ResponseException {
    private int statusCode;

    public HttpException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public HttpException(int statusCode, String message, Throwable cause, String responsePayload) {
        super(message, cause, responsePayload);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getLocalizedMessage() {
        String message = this.getMessage();
        String localizedMessage = "HTTP Code: " + this.statusCode + ". Message: " + (message == null ? "None" : message) + ".";
        if (this.getResponsePayload() != null) {
            localizedMessage = localizedMessage + " Raw response received: " + this.getResponsePayload();
        }
        return localizedMessage;
    }
}

