/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.protocol.http;

import com.amazon.opendistroforelasticsearch.jdbc.protocol.QueryRequest;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.QueryResponse;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.exceptions.ResponseException;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonCursorQueryRequest;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonHttpProtocol;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonQueryResponse;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpTransport;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import java.io.IOException;
import java.io.InputStream;

public class JsonCursorHttpProtocol
extends JsonHttpProtocol {
    public JsonCursorHttpProtocol(HttpTransport transport) {
        this(transport, "/_opendistro/_sql");
    }

    public JsonCursorHttpProtocol(HttpTransport transport, String sqlContextPath) {
        super(transport, sqlContextPath);
    }

    @Override
    public QueryResponse execute(QueryRequest request) throws ResponseException, IOException {
        try (CloseableHttpResponse response = this.getTransport().doPost(this.getSqlContextPath(), defaultJsonHeaders, defaultJdbcParams, this.buildQueryRequestBody(request), 0);){
            QueryResponse queryResponse = this.getJsonHttpResponseHandler().handleResponse(response, this::processQueryResponse);
            return queryResponse;
        }
    }

    private String buildQueryRequestBody(QueryRequest queryRequest) throws IOException {
        JsonCursorQueryRequest jsonQueryRequest = new JsonCursorQueryRequest(queryRequest);
        String requestBody = mapper.writeValueAsString(jsonQueryRequest);
        return requestBody;
    }

    private JsonQueryResponse processQueryResponse(InputStream contentStream) throws IOException {
        return mapper.readValue(contentStream, JsonQueryResponse.class);
    }
}

