/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.protocol.http;

import com.amazon.opendistroforelasticsearch.jdbc.ElasticsearchVersion;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonElasticsearchVersion
implements ElasticsearchVersion {
    private String fullVersion;
    private int[] version = new int[3];

    public JsonElasticsearchVersion(@JsonProperty(value="number") String fullVersion) {
        if (fullVersion == null) {
            return;
        }
        this.fullVersion = fullVersion;
        String[] versionTokens = fullVersion.split("[.-]");
        for (int i = 0; i < versionTokens.length && i < 3; ++i) {
            this.version[i] = this.parseNumber(versionTokens[i]);
        }
    }

    private int parseNumber(String str) {
        int number = 0;
        try {
            number = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    @Override
    public int getMajor() {
        return this.version[0];
    }

    @Override
    public int getMinor() {
        return this.version[1];
    }

    @Override
    public int getRevision() {
        return this.version[2];
    }

    @Override
    public String getFullVersion() {
        return this.fullVersion;
    }
}

